<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Internship Opportunities</title>
  <style>
    :root {
      --primary-color: #3498db;
      --secondary-color: #2c3e50;
      --accent-color: #e74c3c;
      --light-bg: #f8f9fa;
      --dark-text: #343a40;
      --light-text: #6c757d;
    }
    
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f5f7fa;
      color: var(--dark-text);
      line-height: 1.6;
      margin: 0;
      padding: 0;
    }
    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 20px;
    }
    
    header {
      background-color: white;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
      padding: 20px 0;
      margin-bottom: 30px;
    }
    
    .header-content {
      display: flex;
      justify-content: space-between;
      align-items: center;
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 20px;
    }
    
    .logo {
      font-size: 24px;
      font-weight: 700;
      color: var(--primary-color);
    }
    
    .search-filter {
      background-color: white;
      padding: 25px;
      border-radius: 8px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
      margin-bottom: 30px;
    }
    
    .search-bar {
      display: flex;
      gap: 10px;
      margin-bottom: 20px;
    }
    
    .search-bar input {
      flex: 1;
      padding: 12px 15px;
      border: 1px solid #ddd;
      border-radius: 6px;
      font-size: 16px;
    }
    
    .search-bar button {
      background-color: var(--primary-color);
      color: white;
      border: none;
      padding: 0 25px;
      border-radius: 6px;
      cursor: pointer;
      font-weight: 500;
    }
    
    .filters {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
    }
    
    .filter-group {
      flex: 1;
      min-width: 180px;
    }
    
    .filter-group select {
      width: 100%;
      padding: 10px;
      border: 1px solid #ddd;
      border-radius: 6px;
    }
    
    .internship-list {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
      gap: 25px;
    }
    
    .internship-card {
      background-color: white;
      border-radius: 8px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.08);
      overflow: hidden;
      transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .internship-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .card-header {
      padding: 20px;
      border-bottom: 1px solid #eee;
    }
    
    .card-title {
      font-size: 18px;
      font-weight: 600;
      margin-bottom: 5px;
      color: var(--secondary-color);
    }
    
    .card-company {
      color: var(--primary-color);
      font-weight: 500;
      margin-bottom: 10px;
    }
    
    .card-type {
      display: inline-block;
      padding: 3px 8px;
      background-color: #e3f2fd;
      color: var(--primary-color);
      border-radius: 4px;
      font-size: 12px;
      font-weight: 500;
    }
    
    .card-body {
      padding: 20px;
    }
    
    .card-details {
      display: flex;
      flex-wrap: wrap;
      gap: 15px;
      margin-bottom: 15px;
    }
    
    .detail-item {
      display: flex;
      align-items: center;
      gap: 5px;
      color: var(--light-text);
      font-size: 14px;
    }
    
    .detail-item i {
      color: var(--primary-color);
    }
    
    .card-skills {
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
      margin: 15px 0;
    }
    
    .skill-tag {
      background-color: #f1f8fe;
      color: var(--primary-color);
      padding: 4px 10px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 500;
    }
    
    .card-footer {
      padding: 15px 20px;
      background-color: #f9f9f9;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .stipend {
      font-weight: 600;
      color: #27ae60;
    }
    
    .apply-btn {
      background-color: var(--primary-color);
      color: white;
      border: none;
      padding: 8px 20px;
      border-radius: 4px;
      cursor: pointer;
      font-weight: 500;
      transition: background-color 0.3s;
    }
    
    .apply-btn:hover {
      background-color: #2980b9;
    }
    
    .pagination {
      display: flex;
      justify-content: center;
      margin-top: 40px;
      gap: 10px;
    }
    
    .page-btn {
      padding: 8px 15px;
      border: 1px solid #ddd;
      background-color: white;
      border-radius: 4px;
      cursor: pointer;
    }
    
    .page-btn.active {
      background-color: var(--primary-color);
      color: white;
      border-color: var(--primary-color);
    }
    
    @media (max-width: 768px) {
      .header-content {
        flex-direction: column;
        gap: 15px;
      }
      
      .search-bar {
        flex-direction: column;
      }
      
      .internship-list {
        grid-template-columns: 1fr;
      }
    }
  </style>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
  <header>
    <div class="header-content">
      <div class="logo">InternConnect</div>
      <div>
        <button class="apply-btn" style="margin-right: 10px;">Post Internship</button>
        <button class="apply-btn" style="background-color: #27ae60;">Login</button>
      </div>
    </div>
  </header>
  
  <div class="container">
    <div class="search-filter">
      <div class="search-bar">
        <input type="text" placeholder="Search internships by title, company or keyword">
        <button><i class="fas fa-search"></i> Search</button>
      </div>
      <div class="filters">
        <div class="filter-group">
          <select>
            <option value="">All Categories</option>
            <option>Software Development</option>
            <option>Web Development</option>
            <option>Data Science</option>
            <option>Digital Marketing</option>
            <option>Graphic Design</option>
          </select>
        </div>
        <div class="filter-group">
          <select>
            <option value="">All Locations</option>
            <option>Remote</option>
            <option>Mumbai</option>
            <option>Bangalore</option>
            <option>Delhi</option>
            <option>Hyderabad</option>
          </select>
        </div>
        <div class="filter-group">
          <select>
            <option value="">All Types</option>
            <option>Full-time</option>
            <option>Part-time</option>
          </select>
        </div>
        <div class="filter-group">
          <select>
            <option value="">All Durations</option>
            <option>1 month</option>
            <option>2 months</option>
            <option>3 months</option>
            <option>6 months</option>
          </select>
        </div>
      </div>
    </div>
    
    <div class="internship-list">
      <!-- Internship Card 1 -->
      <?php foreach($intern as $data):?>
      <div class="internship-card">
        <div class="card-header">
          <h3 class="card-title"><?= $data['title']?></h3>
          <div class="card-company"><?= $data['category']?></div>
          <span class="card-type"><?= $data['type']?></span>
        </div>
        <div class="card-body">
          <div class="card-details">
            <div class="detail-item">
              <i class="fas fa-briefcase"></i> <?= $data['duration']?>
            </div>
            <div class="detail-item">
              <i class="fas fa-clock"></i> <?= $data['timing']?>
            </div>
            <div class="detail-item">
              <i class="fas fa-map-marker-alt"></i> <?= $data['type']?>
            </div>
            <div class="detail-item">
              <i class="fas fa-graduation-cap"></i> <?= $data['qualification']?>
            </div>
          </div>
          <p><?= $data['description']?></p>
         
       <div class="card-skills">
           
  <?php 
  
  $skills = explode(',', $data['skills']);
 
  foreach ($skills as $skill) {
  
    $cleanSkill = htmlspecialchars(trim($skill));
   
    if (!empty($cleanSkill)) {
      echo '<span class="skill-tag">' . $cleanSkill . '</span>';
    }
  }
  ?>
</div>
        </div>
        <div class="card-footer">
            
          <div class="stipend"><?php if($data['stipend']=="Yes" ){ ?>  ₹ <?= $data['stipendAmount'] ?>
          
          <?php } else { ?>
          
          <?php } ?>
          </div>
          <a href="<?php echo base_url('Apply-Internship-Form/'.$data['id'])?>"><button class="apply-btn">Apply Now</button></a>
        </div>
      </div>
      <?php endforeach;?>
      
    
      
    </div>
    
    <div class="pagination">
      <button class="page-btn"><i class="fas fa-chevron-left"></i></button>
      <button class="page-btn active">1</button>
      <button class="page-btn">2</button>
      <button class="page-btn">3</button>
      <button class="page-btn"><i class="fas fa-chevron-right"></i></button>
    </div>
  </div>
</body>
</html>