<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Membership Application Success</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    
.welcome_card_box{
    display: flex;
    justify-content: center;
    margin: 127px 0px;
    }
       
        .card {
            width: 100%;
            max-width: 500px;
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            animation: fadeIn 0.6s ease-out;
                border-bottom: 3px solid #0a7e6b !important;
    border: 1px solid #0a7e6b;
        }
        
        .welcome_header {
            background: #0a7e6b;
            color: white;
            padding: 10px 20px;
            position: relative;
        }
        
.checkmark-container {
    width: 40px;
    height: 40px;
    background: white;
    border-radius: 50%;
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 0 auto 9px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}        
        
        .checkmark {
            color: #0a7e6b;
            font-size: 20px;
        }
        
h1 {
    font-size: 20px;
    font-weight: 700;
    margin: 0;
}
        
.content {
    padding: 15px 20px 15px 20px;
}        
        
.message {
    font-size: 16px;
    color: #555;
}
        
.registration-number {
    background: #f8f9fc;
    border-radius: 12px;
    padding: 10px;
    margin: 10px 0;
    border: 2px dashed #e3e6f0;
}

.number {
    font-size: 25px;
    font-weight: 800;
    color:  #0a7e6b;
    letter-spacing: 2px;
    /* margin-top: 10px; */
}
        
        .label {
            font-size: 14px;
            color: #858796;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .note {
            background: #f0f7ff;
            border-radius: 10px;
            padding: 15px;
            margin: 20px 0;
            border-left: 4px solid #0a7e6b;
            text-align: left;
        }
        
        .note p {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .note i {
            color: #0a7e6b;
            margin-right: 8px;
        }
        
        .actions {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 30px;
        }
        
.btn-primary {
    width: 200px;
    height: 34px;
    background: #0a7e6b;
    color: white;
    font-size:13px;
    border: none;
    box-shadow: 0 4px 15px rgba(78, 115, 223, 0.3);
}
        

        .btn-primary:hover {
            background: #3a56c4;
            transform: translateY(-2px);
            box-shadow: 0 6px 18px rgba(78, 115, 223, 0.4);
        }
        
        .btn-outline {
            background: white;
            color: #4e73df;
            border: 2px solid #4e73df;
        }
        
        .btn-outline:hover {
            background: #f8f9ff;
            transform: translateY(-2px);
        }
        
        .footer {
            padding: 20px;
            background: #f8f9fc;
            color: #858796;
            font-size: 14px;
        }
        
        .contact {
            margin-top: 10px;
        }
        
        .contact a {
            color: #4e73df;
            text-decoration: none;
        }
        
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        @media (max-width: 576px) {
            .card {
                max-width: 100%;
            }
            
            .content {
                padding: 20px;
            }
            
            .actions {
                flex-direction: column;
            }
            
            .btn-primary{
                margin:auto;
            }
            
            .welcome_card_box{
                padding-left: 10px;
                padding-right: 10px;
            }
        }
    </style>
</head>
<body>
    
    <div class="welcome_card_box">
        <div class="card">
        <div class="welcome_header">
            <div class="checkmark-container">
                <i class="fas fa-check checkmark"></i>
            </div>
            <h1>Congratulations!</h1>
        </div>
        
        <div class="content">
            <p class="message">
                Your membership application has been successfully submitted. Please wait for the administrator to verify your application.
            </p>
            
            <div class="registration-number">
                <div class="label">Your Registration Number</div>
                <div class="number pulse"><?= $users['id']?></div>
            </div>
            
            <div class="note">
                <p><i class="fas fa-info-circle"></i> What happens next?</p>
                <p><i class="fas fa-clock"></i> Verification typically takes 1-2 business days</p>
                <p><i class="fas fa-envelope"></i> You will receive an email notification once verified</p>
                <p><i class="fas fa-user-check"></i> You can then access all member benefits</p>
            </div>
            
            <div class="actions">
                <button class="btn-primary">
                    Account Status <span style="background: #f0f7ff;
    color: #0a7e6b;
    padding: 3px 6px 3px 6px;
    border-radius: 4px;
    margin-left: 5px;"><?= $users['status']?></span>
                </button>
                   <?php if($users['payment_status'] == NULL or $users['payment_status'] == "fail" ) { ?>
    <a href="<?php echo base_url('member_ship_pay_now/'.$users['id'])?>" >
        <button class="btn-primary">Pay Membership Fee<span style="font-weight:600; font-size:15px; margin-left:4px;"></span></button></a>
    <?php } else { ?> 
  <div>
       <a href="#" class="btn btn-primary"> Membership Fee Already Paid<span style="font-weight:600; font-size:13px; margin-left:4px;"></span></a>
  </div>
  
  

    <?php } ?>
            </div>
        </div>
        

    </div>
    </div>

    <script>
        // Simple animation for the registration number
        setInterval(function() {
            document.querySelector('.pulse').classList.toggle('pulse');
        }, 2000);
    </script>
</body>
</html>