<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Card Holder Dashboard</title>
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body{font-family:Poppins,Arial;background:#f4f7fb;margin:0;padding:24px;color:#14233a}
        .wrap{max-width:1100px;margin:0 auto}
        .top{display:flex;justify-content:space-between;align-items:center;margin-bottom:20px}
        .cardBox{background:#fff;padding:18px;border-radius:10px;box-shadow:0 6px 18px rgba(20,40,80,.06);margin-bottom:16px}
        h1{margin:0;font-size:20px;color:#0f1724}
        .small{color:#667085;font-size:14px}
        .grid{display:grid;grid-template-columns:1fr 360px;gap:18px}
        .left, .right{min-height:200px}
        table{width:100%;border-collapse:collapse}
        table th, table td{padding:10px;border:1px solid #eef2f7;text-align:left;font-size:14px}
        .btn{display:inline-block;padding:8px 12px;border-radius:8px;background:#2a9d8f;color:#fff;text-decoration:none}
        .btn-danger{background:#e74c3c}
        .muted{color:#586274;font-size:13px}
    </style>
</head>
<body>
    <div class="wrap">
        <div class="top">
            <div>
                <h1>Welcome, <?= esc(session()->get('card_holder_name')) ?></h1>
                <div class="small">Card #: <strong><?= esc($card['card_number']) ?></strong> &nbsp; | &nbsp; DOB: <?= esc($card['dob']) ?></div>
            </div>
            <div>
                <a href="<?= base_url('card-logout') ?>" class="btn btn-danger">Logout</a>
            </div>
        </div>

        <div class="grid">
            <div class="left">
                <!-- Health card summary -->
                <div class="cardBox">
                    <h2 style="margin-bottom:6px">Health Card</h2>
                    <div class="small">Name: <strong><?= esc($card['name']) ?></strong></div>
                    <div class="small">Father: <?= esc($card['father_name'] ?? '-') ?></div>
                    <div class="small">Mobile: <?= esc($card['mobile'] ?? '-') ?></div>
                    <div class="small">Address: <?= esc($card['full_address'] ?? '-') ?></div>
                    <div style="margin-top:10px">
                        <strong>Status:</strong>
                        <?php if ($total_paid >= 551): ?>
                            <span style="color:green">Payment Complete</span>
                        <?php else: ?>
                            <span style="color:orange">Payment Pending</span>
                        <?php endif; ?>
                    </div>

                    <div style="margin-top:12px">
                        <strong>Total Paid:</strong> ₹<?= number_format($total_paid, 2) ?>
                        &nbsp; | &nbsp;
                        <strong>Required Fee:</strong> ₹<?= number_format($total_paid-$card_fee, 2) ?>
                    </div>

                    <?php if (!$is_complete): ?>
                        <div style="margin-top:12px;">
                            <a href="<?= base_url('health-card-payment/'.$card['id']) ?>" class="btn">Pay Now</a>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Family Members -->
                <div class="cardBox">
                    <h3>Family Members</h3>
                    <?php if (!empty($members)): ?>
                        <table>
                            <thead><tr><th>#</th><th>Name</th><th>Relation</th><th>Age</th></tr></thead>
                            <tbody>
                                <?php $i=1; foreach($members as $m): ?>
                                    <tr>
                                        <td><?= $i++ ?></td>
                                        <td><?= esc($m['name']) ?></td>
                                        <td><?= esc($m['relation']) ?></td>
                                        <td><?= esc($m['age']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="muted">No family members recorded.</div>
                    <?php endif; ?>
                </div>

                <!-- Payment History -->
                <div class="cardBox">
                    <h3>Payment History</h3>
                    <?php if (!empty($transactions)): ?>
                        <table>
                            <thead><tr><th>#</th><th>Transaction ID</th><th>Amount</th><th>Status</th><th>Date</th></tr></thead>
                            <tbody>
                                <?php $i=1; foreach($transactions as $t): ?>
                                    <tr>
                                        <td><?= $i++ ?></td>
                                        <td><?= esc($t['transactionId'] ?? $t['transaction_id'] ?? '-') ?></td>
                                        <td>₹<?= number_format(floatval($t['amount']),2) ?></td>
                                        <td><?= esc($t['payment_status'] ?? $t['status'] ?? '-') ?></td>
                                        <td><?= esc(date('d-m-Y H:i', strtotime($t['created_at'] ?? $t['updated_at'] ?? 'now'))) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="muted">No payment records yet.</div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="right">
                <div class="cardBox">
                    <h3>Download / Print Card</h3>
                    <p class="small">Download a printable version of your health card.</p>
                    <a class="btn" href="<?= base_url('healthCardDownload/'.$card['id']) ?>">Download Health Card</a>
                </div>

                <div class="cardBox" style="margin-top:12px">
                    <h3>Help & Support</h3>
                    <p class="small">If you need help with payment or account, contact support@yourdomain.com or call +91-XXXXXXXXXX</p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
