<!DOCTYPE html>
<html lang="en">
<head>
  <title>Payment Gateway</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <style>
    * {
      font-family: 'Poppins', sans-serif;
    }
    .main_box {
      width: 100%;
      padding-bottom: 60px;
      padding-top: 25px;
      box-shadow: rgba(0, 0, 0, 0.15) 0px 15px 25px, rgba(0, 0, 0, 0.05) 0px 5px 10px;
      border-radius: 10px;
      background: rgb(14 109 96) !important;
    }
    .container {
      width:100%;
      max-width:1200px;
      margin:auto;
    }
    .id_lable {
      color:white !important;
      font-size: 14px !important;
      display: flex;
    }
    .payment-processing {
      text-align: center;
      padding: 20px;
      background: #f8f9fa;
      border-radius: 8px;
      margin: 20px 0;
    }
    .spinner {
      width: 50px;
      height: 50px;
      border: 5px solid #f3f3f3;
      border-top: 5px solid #3498db;
      border-radius: 50%;
      animation: spin 1s linear infinite;
      margin: 20px auto;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
    table {
      width: 100%;
      border-collapse: collapse;
      border: 2px solid #fff;
      margin-bottom:20px;
    }
    th, td {
      padding: 5px;
      text-align: left;
      border-bottom: 2px solid #fff;
      border-left: 2px solid #fff;
    }
    .refresh {
      font-size:24px;
      margin-top:0px;
      color: #ffffff;
      text-shadow: 0px 4px 2px black;
    }
    .panel-heading {
      font-size: 20px !important;
      text-transform: capitalize;
      color: white;
    }
    .panel-body {
      background:#1f2937d9 !important;
    }
    .razorpay-payment-button {
      display: none !important;
    }
    .manual-pay-btn {
      background: #ff7529;
      color: white;
      border: none;
      padding: 10px 20px;
      border-radius: 4px;
      font-size: 16px;
      cursor: pointer;
      margin: 20px auto;
      display: block;
    }
    .hidden {
      display: none !important;
    }
    .success-message {
      color: #4CAF50;
      font-weight: bold;
      text-align: center;
      padding: 15px;
      background: rgba(76, 175, 80, 0.1);
      border-radius: 5px;
      margin: 20px 0;
    }
  </style>
</head>
<body>
<div class="container">
  <div class="row">
    <div class="col-xl-3 col-lg-3 col-md-3"></div>
    <div class="col-xl-6 col-lg-6 col-md-6">
      <div class="panel" style="margin-top: 60px !important; background:#0a7e6b;">
        <?php 
          require 'db_config.php';
          $queryli = "SELECT * FROM `admin_website_update`";
          $result = mysqli_query($connection, $queryli);
          $datamsg = mysqli_fetch_array($result, MYSQLI_ASSOC);
        ?>
        
        <div class="panel-heading text-center">
          <span><?php echo $datamsg['web_name']?></span>
        </div>
        
        <div class="panel-body">
          <div style="text-align: center;">
            <h3 class="refresh" id="statusMessage">
              <?php echo isset($_GET['payment_status']) ? 'Payment Successful!' : 'Please Wait, Payment Processing'; ?>
            </h3>
            
            <?php if (isset($_GET['payment_status']) && $_GET['payment_status'] === 'success'): ?>
              <div class="success-message">
                Your payment has been processed successfully!
              </div>
            <?php else: ?>
              <div class="payment-processing" id="processingSection">
                <div class="spinner"></div>
                <p>Processing your payment...</p>
                <p>Do not refresh or go back during this process</p>
              </div>
            <?php endif; ?>
            
            <div class="row">
              <div class="col-xl-1 col-lg-1 col-md-1"></div>
              <div class="col-xl-10 col-lg-10 col-md-10">
                <div class="main_box">
                  <div class="container">
                    <table>
                      <tr>
                        <td><label class="id_lable">User ID:</label></td>
                        <td><label class="id_lable"><?php echo $users['id'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Name:</label></td>
                        <td><label class="id_lable"><?php echo $users['name'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Email:</label></td>
                        <td><label class="id_lable"><?php echo $users['email'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Mobile No:</label></td>
                        <td><label class="id_lable"><?php echo $users['mobile'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Amount:</label></td>
                        <td><label class="id_lable">₹<?php echo $amount;?></label></td>
                      </tr>
                    </table>
                  </div>
                </div>
              </div>
              <div class="col-xl-1 col-lg-1 col-md-1"></div>
            </div>
          </div>

          <?php if (session()->has('error')) { ?>
            <div class="alert alert-danger alert-dismissible fade in" role="alert">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">×</span>
              </button>
              <strong>Error!</strong> <?=session("error")?>
            </div>
          <?php } ?>

          <?php if (!isset($_GET['payment_status'])): ?>
            <form action="<?= base_url('EventPayment') ?>" method="POST" id="paymentForm">
              <script src="https://checkout.razorpay.com/v1/checkout.js"
                data-key="<?= $dataweb['merchantId'] ?>"
                data-amount="<?= $amount * 100 ?>"
                data-currency="INR"
                data-order_id="<?= $order_id ?>"
                data-buttontext="Pay ₹<?= $amount ?>"
                data-name="<?= htmlspecialchars($datamsg['web_name']) ?>"
                data-description="Payment"
                data-image="<?= base_url('websiteLogoImages/'.$datamsg['web_logo']) ?>"
                data-prefill.name="<?= htmlspecialchars($users['name']) ?>"
                data-prefill.email="<?= htmlspecialchars($users['email']) ?>"
                data-prefill.contact="<?= htmlspecialchars($users['mobile']) ?>"
                 data-notes.user_id="<?= htmlspecialchars($users['id']) ?>"
                data-theme.color="#ff7529"
                data-callback="handlePaymentResponse">
              </script>
              <input type="hidden" name="user_id" value="<?= $users['id'] ?>">
              <input type="hidden" name="amount" value="<?= $amount ?>">
              <input type="hidden" name="order_id" value="<?= $order_id ?>">
            </form>
            
            <button id="manualPayBtn" class="manual-pay-btn"> ₹<?= $amount ?></button>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="col-xl-3 col-lg-3 col-md-3"></div>
  </div>
</div>

<script>
  $(document).ready(function() {
    // Check if payment is already completed (callback received)
    if(window.location.search.includes('payment_status=success')) {
      hidePaymentButtons();
      document.getElementById('statusMessage').textContent = 'Payment Successful!';
      return;
    }
    
    // Auto-trigger payment button after page loads
    setTimeout(function() {
      $('.razorpay-payment-button').click();
    }, 1000);
    
    // Manual trigger button as fallback
    $('#manualPayBtn').click(function() {
      $('.razorpay-payment-button').click();
      $('#processingSection').show();
    });
    
    // Handle Razorpay callback
    function handlePaymentResponse(response) {
      hidePaymentButtons();
      $('#processingSection').show();
      document.getElementById('statusMessage').textContent = 'Payment Successful!';
      
      // Verify payment on server side
      verifyPayment(response.razorpay_payment_id, response.razorpay_order_id, response.razorpay_signature);
    }
    
    function hidePaymentButtons() {
      $('#manualPayBtn').addClass('hidden');
      $('.razorpay-payment-button').addClass('hidden');
      $('#paymentForm').addClass('hidden');
    }
    
    function verifyPayment(paymentId, orderId, signature) {
      $.ajax({
        url: '<?= base_url('verify_payment') ?>',
        type: 'POST',
        data: {
          payment_id: paymentId,
          order_id: orderId,
          signature: signature
        },
        success: function(response) {
          if(response.success) {
            // Redirect to success page or show success message
            window.location.href = window.location.href + '?payment_status=success';
          } else {
            document.getElementById('statusMessage').textContent = 'Payment Verification Failed';
          }
        },
        error: function() {
          document.getElementById('statusMessage').textContent = 'Error verifying payment';
        }
      });
    }
  });
</script>
</body>
</html>