<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head><meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
    
 
  <title>Donation Receipt</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <link rel="stylesheet" href="<?php echo base_url('public/css/visitor_donate_receipt.css')?>">
  <script src="<?php echo base_url('public/qrcode.min.js')?>"></script>
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://rawgit.com/eKoopmans/html2pdf/master/dist/html2pdf.bundle.js"></script>
  
<style>
  
.watermark {
      position: fixed;
      opacity: 0.2;
      font-size: 80px;
      width: 100%;
      text-align: center;
      z-index: 1000;
      transform: rotate(-45deg);
      transform-origin: 50% 50%;
      pointer-events: none;
      top: 50%;
      left: 0;
      font-weight: bold;
      color: red;
}
    
  </style>
  
</head>
<body style="margin: 0;">

<div class="bg-dark background_color background_color2">
    <div class="body1" id="content-to-print">
  <div class="receipt-wrapper">
       <div class="watermark" id="watermark" style="<?php echo ($payments['payment_status'] == 'fail' || $payments['payment_status'] == 'PAYMENT_PENDING') ? 'display:block;' : 'display:none;'; ?>">FAILED</div>

    <div class="fail-message" id="failMessage" style="<?php echo ($payments['payment_status'] == 'fail' || $payments['payment_status'] == 'PAYMENT_PENDING') ? 'display:block;' : 'display:none;'; ?>">
       This transaction has failed. Please contact support if amount is deducted.
    </div>



    <div class="header">
      <div>
        <p style="width: 180px; padding: 6px; font-weight: 600; background: #f2f2f2;">
          <i class="fa-solid fa-receipt"></i> Event Registration Receipt
        </p>
      </div>
      <div class="logo_box">
        <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" alt="logo" class="logo">
        <div class="line"></div>
      </div>
      <h2><?php echo $dataweb['web_name']?></h2>
      <p><b>Registration Number:</b> MH/2021/0277920</p>
      <p><b>Niti Aayog Reg No:</b> ghkhk | <b>80G Reg No:</b> wrrdE12/2024 | <b>12A Reg No:</b> hjkhgjk | <b>PAN No:</b> kghjk</p>
      <p><i class="fas fa-map-marker-alt icon"></i> <?php echo $dataweb['website_address']?></p>
      <p><i class="fas fa-phone icon"></i> <?php echo $dataweb['site_mobile_1']?> | <i class="fas fa-envelope icon"></i> <?php echo $dataweb['webemail_1']?> | <i class="fas fa-globe icon"></i> www.<?php echo $dataweb['site_url']?></p>
    </div>

    <div class="receipt-no">
      Receipt No: 
     ENT<?= $payments['event_id']?>RCP<?php echo $payments['id']?>
    </div>

    <table class="details-table">
      <tr><th colspan="2"><i class="fas fa-user icon"></i> Donor Information</th></tr>
      <tr><td width="30%"><b>Full Name</b></td><td><?php echo $payments['name']?></td></tr>
      <tr><td><b>Address</b></td><td><?php echo $payments['address']?></td></tr>
     
    </table>

    <table class="details-table">
      <tr><th colspan="2"><i class="fas fa-hand-holding-heart icon"></i> Donation Details</th></tr>
      <tr><td><b>Amount</b></td><td><?php echo $payments['amount']?> <span class="amount-in-words">(<?php echo $datarecipt['formatteword'];?> Rupees Only)</span></td></tr>
      <tr><td><b>Payment Mode</b></td><td><i class="fas fa-mobile-alt icon"></i> Online </td></tr>
      <tr><td><b>Date of Donation</b></td><td><i class="far fa-calendar-alt icon"></i> <?php echo $datarecipt['formattedDate']; ?></td></tr>
      <tr><td><b>Event Name</b></td><td><i class="fas fa-book icon"></i> <?php echo $event['name']?></td></tr>
      <tr>
        <td><b>Status</b></td>
        <td> <?php if($payments['payment_status'] == 'fail' || $payments['payment_status'] == 'PAYMENT_PENDING'){ ?>
        <strong style="color:red;">Fail</strong> <?php } else { ?>
          <strong style="color:green;">Success</strong>
          <?php } ?>
        </td>
      </tr>
    </table>

    <div class="qr-signature-section">
      <div class="qr-code">
        <p><strong>Scan QR for Verification</strong></p>
        <div class="member_qr_box">
          <div id="qrcoder"></div>
        </div>
      </div>
      <div class="signature-block">
        <label style="padding: 3px 20px; border-bottom: 1px solid grey;">
          <img src="<?php echo base_url('certificateProviderSignature/'.$dataweb['certificate_provider_signature'])?>" alt="logo" class="logo" style="transform: translate(0px, 7px);">
        </label>
        <p><strong><?php echo $dataweb['certificate_provider_name']?><br>(<?php echo $dataweb['designation']?>)</strong></p>
        <p>Authorised Signatory</p>
        <p><i class="fas fa-stamp icon"></i> <?php echo $dataweb['web_name']?></p>
      </div>
    </div>

    <div class="footer-info">
      <p><i class="fas fa-info-circle icon"></i> This donation is eligible for 50% tax deduction under Section 80G of Income Tax Act, 1961 </p>
      <p><strong>Thank you for your generous support !</strong></p>
    </div>

  </div>
</div>

<!-- Download Button -->
<div class="main_btn_box">
<?php $session = session();
if($session->id){ ?>
<button class="download_btn download-btn"><a href="<?= str_replace('software/','', base_url()) ?>" style="text-decoration:none;">Go Back</a></button>

    <?php } else{ ?>
    <button class="download_btn download-btn"><a href="<?= str_replace('software/','', base_url()) ?>" style="text-decoration:none;">Go Back</a></button>
    <?php } ?>
    <button class="download-btn" onclick="window.print()"><i class="fas fa-download"></i> Download PDF</button>
</div>
</div>

<!-- QR Code Script -->
<?php $content = base_url('event_registeration_receipt_download/'.$payments['id']); ?>
<script>
  var content = "<?php echo $content ?>";
  var qrcoder = new QRCode(document.getElementById("qrcoder"), {
    text: content,
    width: 90,
    height: 90,
  });
</script>

</body>
</html>