 <?php
               
               $session = session();
               $admin_id = $session->admin_id;
                        require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="description" content="app, web app, responsive, admin dashboard, admin, flat, flat ui, ui kit, off screen nav" /> 
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" /> 
    <title><?= esc($heading ?? 'Project-Expense-Details') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo base_url('public/css/popup.css')?>" type="text/css" />
    <link rel="stylesheet" href="<?php echo base_url('public/css/app.v1.css')?>" type="text/css" />
    
    <style>
        .section-box {
            width:450px;
            border: 1px solid #ddd;
            padding: 30px;
            margin-bottom: 20px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
            margin:auto;
            background: #fff;
        }
        img.project-image, img.receipt-image {
            max-width: 100%;
            border-radius: 8px;
        }
        .label {
            font-weight: bold;
            color: #444;
        }
        
                table{
            margin:0 !important;
        }
        
.member_ship_box{
    width: 90px;
    height: 90px;
    border-radius: 50%;
    padding: 4px;
    background: white;
    margin: auto;
    transform: translate(0px, 70px);
    box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
    position: relative;
    z-index:1;
}

.winggo_logo_radius{
    width:100%;
    height:100%;
}
    
.icon-box {
     width: 42px;
     height: 42px;
     background-color: #e9f7ef;
     display: flex;
     align-items: center;
     justify-content: center;
     color: #0a7e6b;
}
    
.control-label{
    display: flex;
    align-items: center;
    gap:10px;
    margin:0 !important;
    color: black;
    font-weight: 600;
}

td{
    padding:0 !important;
}
    
td p{
    padding-left: 5px;
    margin: 0;
    padding-top: 10px;
}

.project-image{
    width: 72px;
    height: 72px;
    padding: 5px;
    object-fit: unset;
}

@media(max-width:500px){
    .section-box{
        width:100% !important;
    }
}
        
    </style>
</head>
<body>

<div class="bg-dark background_color background_color2">
    <div class="member_ship_box">
		 <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
	</div>
    <div class="container py-5">
        
    <!-- Project Details -->
    <div class="section-box">
        <h2 class="mb-4" style="font-size: 20px; text-align: center; font-weight: 600;"><?= esc($heading) ?></h2>
        <h4 style="font-size: 20px; text-align: center; background: #00665f; color: white; padding: 5px; border-radius: 4px;">Project Details</h4>
       
<table class="table table-bordered">
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-regular fa-id-card"></i></div>Title:
            </label>
        </td>
        <td><p><?= esc($project['title']) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-audio-description"></i></div>Description:
            </label>
        </td>
        <td><p><?= nl2br(esc(trim($project['description']))) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-indian-rupee-sign"></i></div>Target Amount:
            </label>
        </td>
        <td><p>₹<?= number_format($project['target_amount']) ?></p></td>
    </tr>

    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-layer-group"></i></div>Category:
            </label>
        </td>
        <td><p><?= esc($project['category']) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-location-dot"></i></div>Location:
            </label>
        </td>
        <td><p><?= esc($project['location']) ?></p></td>
    </tr>

    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-square-check"></i></div>Status:
            </label>
        </td>
        <td><p><span class="badge bg-warning text-dark"><?= esc(ucfirst($project['status'])) ?></span></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-calendar"></i></div>Created At:
            </label>
        </td>
        <td><p><?= date('d M Y, h:i A', strtotime($project['created_at'])) ?></p></td>
    </tr>
    
    <?php if (!empty($project['image'])): ?>
    
     <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-image"></i></div>Image:
            </label>
        </td>
        <td><img src="<?= base_url('DonationProjectsImage/' . $project['image']) ?>" class="project-image" alt="Project Image"></td>
    </tr>
    <?php endif; ?>

</table>

<!-- Expense Details -->

    <div>
        <h4 style="font-size: 20px; text-align: center; background: #00665f; color: white; padding: 5px; border-radius: 4px;"> Expense Details</h4>
       
<table class="table table-bordered">
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-user"></i></div>Name:
            </label>
        </td>
        <td><p><?= esc($expense['name']) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-indian-rupee-sign"></i></div>Amount:
            </label>
        </td>
        <td><p>₹<?= esc(number_format($expense['amount'], 2)) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-brands fa-product-hunt"></i></div>Product Name:
            </label>
        </td>
        <td><p><?= esc($expense['product_name']) ?></p></td>
    </tr>

    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-layer-group"></i></div>Expense Category:
            </label>
        </td>
        <td><p><?= esc($expense['expense_category']) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-location-dot"></i></div>Paid To:
            </label>
        </td>
        <td><p><?= esc($expense['paid_to']) ?></p></td>
    </tr>

    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-square-check"></i></div>Payment Mode:
            </label>
        </td>
        <td><p><?= esc($expense['payment_mode']) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-calendar"></i></div>Expense Date:
            </label>
        </td>
        <td><p><?= esc(date('d M Y, h:i A', strtotime($expense['expense_date']))) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-calendar"></i></div>Description:
            </label>
        </td>
        <td><p><?= nl2br(esc($expense['description'])) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-calendar"></i></div>Receipt ID:
            </label>
        </td>
        <td><p><?= esc($expense['receipt_id']) ?></p></td>
    </tr>
    
    <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-calendar"></i></div>Created At:
            </label>
        </td>
        <td><p><?= esc(date('d M Y, h:i A', strtotime($expense['created_at']))) ?></p></td>
        
    </tr>
    
    <?php if (!empty($expense['receipt_image'])): ?>
    
     <tr>
        <td>
            <label class="control-label">
                <div class="icon-box"><i class="fa-solid fa-image"></i></div>Receipt Image:
            </label>
        </td>
        <td>
        <img src="<?= base_url('ProjectExpenseImage/' . $expense['receipt_image']) ?>" alt="Receipt Image" class="project-image">
    </tr>
    <?php endif; ?>

</table>

<button onclick="history.back()" class="btn btn-primary btn-block" style="outline:none; margin-top: 2%;">Go Back</button>         
        
    </div>
        
    </div>

    </div>
</div>
    

</body>
</html>
