<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Project Expense Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>

    <style>
        /* Responsive scaling without meta viewport */
        html {
            transform: scale(calc(100vw / 1200));
            transform-origin: top left;
            width: 1200px;
            overflow-x: hidden;
        }
        @media (max-width: 1200px) {
            html {
                transform: scale(calc(100vw / 1200));
            }
        }

        /* keep your existing styles here (no change) */

table{
    margin-top: 15px !important;
    border: 1px solid #d4efda !important;
}
        
th, td {
    text-align: left;
    border-bottom: 1px solid #d4efda !important;
    border-left: 1px solid #d4efda !important;
}

.member_ship_box{
    width: 90px;
    height: 90px;
    border-radius: 50%;
    padding: 4px;
    background: white;
    margin: auto;
    /*transform: translate(0px, 35px);*/
    box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
}

.winggo_logo_radius{
    width:100%;
    height:100%;
}

 header {
      background: #f0f7f4;
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 16%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: black;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: white;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background: #168060;
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

    header nav a:hover {
      color: white;
    }
    
  /* Footer */
    footer {
      background: #1a3c32;
    color: white;
    padding-bottom: 15px;
    }
    
.logo_box {
    width: 100px;
    height: 100px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: #1a936f;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
    padding-top: 20px;
}

    .footer-column h3 {
      margin-bottom: 20px;
      font-size: 1.3rem;
      position: relative;
      padding-bottom: 10px;
    }

    .footer-column h3::after {
      content: '';
      position: absolute;
      left: 0;
      bottom: 0;
      width: 40px;
      height: 2px;
      background: #1a936f;
    }

    .footer-column p, .footer-column a {
      color: white;
      margin-bottom: 10px;
      display: block;
      text-decoration: none;
      transition: color 0.3s;
    }


    .copyright {
      text-align: center;
      border-top: 1px solid rgba(255,255,255,0.1);
      color: #aaa;
      font-size: 0.9rem;
    }    
  
@media(max-width:500px){
    header {
         padding: 23px 1% !important;
         gap: 20px !important;
         flex-flow: column !important; 
    }
    
     .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }
    
}  

.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background: #188b69;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}    

    </style>
</head>
<body>

<div style="width:127%;">
    <a href="#" class="direct_top"><i class="fa-solid fa-arrow-up"></i></a>

<!-- Header Section -->
  <header>
    <!-- Left Side: Logo + NGO Name -->
    <div class="logo-area">
       <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
      <div>
          <h2><?php echo $dataweb['web_name']?></h2>
          <p style="margin:0; color:black;"><?php echo $dataweb['web_tag_line']?></p>
      </div>
    </div>

    <!-- Right Side: Navigation -->
    <nav>
      <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
            <i class="fa-solid fa-house-user"></i> Home
        </a>
        
      <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: white;
    padding-left: 20px;
    text-decoration: none;">
    <i class="fa-solid fa-phone"></i> 
    <?php echo $dataweb['site_mobile_1'] ?>
</a>

    </nav>
    
 <div class="text-center">
                <button id="generatePdf" class="btn btn-pdf" style="background: #00a783 !important; color: white !important;"><i class="fa-solid fa-cloud-arrow-down"></i> Generate PDF Report</button>
            </div>
    
  </header>    
    
<div class="container-fluid" id="report-content">
   
    <div class="row justify-content-center">
        <div class="col-lg-11 col-xl-10" style="margin-bottom: 30px;">
            <div class="report-container" id="report-content">
           <!--      <div class="member_ship_box">-->
		         <!--   <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">-->
		         <!--</div>-->
		         <h1 style="text-align: center;
    font-size: 30px;
    font-weight: 700; padding-top:30px;">Shri Ram Navyug Trust</h1>
                <!-- Header -->
                <div class="report-header">
                    <h1 style="font-size: 30px; font-weight: 600;"><i class="fa-solid fa-indian-rupee-sign" style="font-size: 25px; padding-right: 9px;"></i>Project Expense Report</h1>
                    <p class="mb-0">Detailed breakdown of project expenses and funding</p>
                </div>

                <div class="report-body">
                    <!-- Project Summary -->
                    <div class="summary-card">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h2 class="mb-3"><?= esc($project['title']) ?></h2>
                                <p class="mb-2"><i class="fas fa-info-circle me-2"></i><strong>Description:</strong> <span style="text-transform: capitalize;"><?= esc($project['description']) ?></span></p>
                                <p class="mb-2"><i class="fas fa-tag me-2"></i><strong>Category:</strong> <span style="text-transform: capitalize;"><?= esc($project['category']) ?></span></p>
                                <p class="mb-2"><i class="fas fa-user me-2"></i><strong>Created By:</strong> <span style="text-transform: capitalize;"><?= esc($project['title']) ?></span></p>
                               
                            </div>
                            <div class="col-md-4 text-center">
                                <i class="fas fa-donate summary-icon"></i>
                                <div class="total-amount">₹<?= number_format($project['target_amount'], 2) ?></div>
                                <p class="mb-0">Main Expense Amount</p>
                                <p class="expense-date mt-2">Created: <?= date('F j, Y', strtotime($project['created_at'])) ?></p> 
                            </div>
                        </div>
                    </div>

                    <!-- Expense Details -->
                    <div class="detail-card">
                        <div class="detail-card-header">
                            <i class="fas fa-receipt me-2"></i>Expense Details
                        </div>
                        <div class="card-body" style="    width: 98% !important;">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Item</th>
                                        <th>Category</th>
                                        <th>Paid To</th>
                                        <th>Payment Mode</th>
                                        <th class="text-end">Amount (₹)</th>
                                        
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $total = 0; ?>
                                    <?php foreach($expenses as $exp): ?>
                                        <?php $total += $exp['amount']; ?>
                                        <tr>
                                            <td><?= date('M j, Y', strtotime($exp['expense_date'])) ?></td>
                                            <td><?= esc($exp['product_name']) ?></td>
                                            <td><span class="badge bg-info"><?= esc($exp['expense_category']) ?></span></td>
                                            <td><?= esc($exp['paid_to']) ?></td>
                                            <td><span class="badge bg-secondary"><?= esc($exp['payment_mode']) ?></span></td>
                                            <td class="text-end amount-cell"><?= number_format($exp['amount'], 2) ?></td>
                                           
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                    <tfoot>
                                    <tr class="table-active">
                                        <th colspan="5" class="text-end">Total Expenses:</th>
                                        <th class="text-end">₹<?= number_format($total, 2) ?></th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Notes Section -->
                    <div class="detail-card">
                        <div class="detail-card-header">
                            <i class="fas fa-sticky-note me-2"></i>Additional Notes
                        </div>
                        <div class="card-body">
                            <p class="mb-0">This report contains all expenses related to project <strong><?= esc($project['title']) ?></strong> as of <?= date('F j, Y') ?>. All amounts are in Indian Rupees (₹). This report was automatically generated by the system.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- PDF Button -->
           
        </div>
    </div>
</div>
 <!--<div class="text-center mt-4 mb-4">-->
 <!--               <button id="generatePdf" class="btn btn-pdf" style="background: #00a783 !important; color: white !important;"><i class="fa-solid fa-cloud-arrow-down"></i> Generate PDF Report</button>-->
 <!--           </div>-->
<!-- Receipt Modal -->
<div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Expense Receipt</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalReceiptImg" src="" alt="Receipt" class="img-fluid rounded">
            </div>

        </div>
    </div>
</div>

<!-- Footer -->
  <footer>
      <div style="padding-top:25px;">
          <div class="logo_box">
              <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
        </div>
      </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
    <div class="footer-content">
        
      <div class="footer-column">
        <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
      </div>
      <div class="footer-column">
        <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
       
      </div>
      <div class="footer-column">
        <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
        
      </div>
    </div>
    <div class="copyright">
       <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
        <!-- / footer -->
    </div>
  </footer>    
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Generate PDF
        document.getElementById('generatePdf').addEventListener('click', function() {
            window.scrollTo(0, 0);
            const element = document.getElementById('report-content');
            const button = this;

            const originalText = button.innerHTML;
            button.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Generating PDF...';
            button.disabled = true;

            const opt = {
                margin: [10, 5, 10, 5],
                filename: 'project-expense-report-<?= $project['id'] ?>.pdf',
                image: { type: 'jpeg', quality: 0.98 },
                html2canvas: { scale: 2, useCORS: true },
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' },
                pagebreak: { mode: ['avoid-all', 'css', 'legacy'] }
            };

            html2pdf().set(opt).from(element).save().then(() => {
                button.innerHTML = originalText;
                button.disabled = false;
            }).catch(error => {
                console.error('PDF generation failed:', error);
                button.innerHTML = originalText;
                button.disabled = false;
                alert('PDF generation failed. Please try again.');
            });
        });

        // Modal image preview
        const receiptModal = document.getElementById('receiptModal');
        receiptModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const imgSrc = button.getAttribute('src');
            document.getElementById('modalReceiptImg').src = imgSrc;
        });
    });
</script>
</body>
</html>
