<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enquiry Form</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            /*background-color: #f5f7fa;*/
            margin: 0;
            padding: 5px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 90vh;
        }
        
        .enquiry-form {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 600px;
            padding: 30px;
        }
        
        .form-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .form-header h2 {
            color: #2c3e50;
            margin-bottom: 10px;
            margin-top: 0;
        }
        
        .form-header p {
            color: #7f8c8d;
            margin: 0;
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2c3e50;
            font-weight: 600;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px 12px 40px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #3498db;
            outline: none;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.2);
        }
        
        .icon {
            position: absolute;
            left: 15px;
            top: 46px;
            color: #7f8c8d;
        }
        
        textarea.form-control {
            min-height: 120px;
            padding-left: 15px;
        }
        
        .submit-btn {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s;
        }
        
        .submit-btn:hover {
            background-color: #2980b9;
        }
        
        .text-danger {
            color: red;
            font-size: 0.875em;
        }

        /* Success Message Alert */
        .alert-success-popup {
             position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.6);
   
    justify-content: center;
    align-items: center;
    z-index: 9999;
    backdrop-filter: blur(5px);
        }
        .popbox1 {
    background: #fff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
    position: relative;
    max-width: 450px;
    width: 90%;
    text-align: center;
    animation: popUp 0.3s ease-out forwards;
    transform: translate(220px, 376px);
}

        .alert-success-popup.show {
            transform: translateX(0);
        }

        .alert-success-popup .close-btn {
            background: none;
            border: none;
            color: #155724;
            font-size: 18px;
            cursor: pointer;
            margin-left: 15px;
            padding: 0;
            line-height: 1;
        }

        .alert-success-popup .message-content {
            flex-grow: 1;
        }

        @media (max-width: 768px) {
            .enquiry-form {
                padding: 20px;
            }
            .alert-success-popup {
                max-width: calc(100% - 40px);
                right: 20px;
                left: 20px;
            }
            
            .header_heading{
               font-size: 13px !important;
                
            }
        }
        
.main_popup_box{
    right: 0;
    left: 0;
    margin: auto;
}   

.header_heading{
    font-size: 15px;
    margin: 0;
}
    </style>
</head>
<body>
    <?php $session = session() ?>
    <div class="enquiry-form">
        <div class="form-header">
            <h2><i class="fas fa-envelope-open-text"></i> Contact Us</h2>
            <h3 class="header_heading" style="padding-top: 7px;">संस्था में पूछताछ करने के लिए नीचे दिया गया Enquiry Form भरें।</h3>
            <h3 class="header_heading">For enquiries, please fill out the form below.</h3>
        </div>
        
        <?php if(! is_null($session->getFlashdata('success')) ):?>
         
         <?php include(__DIR__ . '/../success/success.php'); ?>

<? endif;?>


 <?php if(session()->getFlashdata('error')): ?>
         
         <?php include(__DIR__ . '/../errors/error.php'); ?>

<? endif;?>
        
        <form action="<?= base_url('Enquiry-Form-Data') ?>" method="POST">
            <div class="form-group">
                <label for="name">Full Name</label>
                <i class="fas fa-user icon"></i>
                <input type="text" id="name" name="name" class="form-control" value="<?= old('name') ?>" required>
                <small class="text-danger"><?= session('validation') ? session('validation')->getError('name') : '' ?></small>
            </div>

            <div class="form-group">
                <label for="email">Email Address</label>
                <i class="fas fa-envelope icon"></i>
                <input type="email" id="email" name="email" class="form-control" value="<?= old('email') ?>" required>
                <small class="text-danger"><?= session('validation') ? session('validation')->getError('email') : '' ?></small>
            </div>

            <div class="form-group">
                <label for="phone">Phone Number</label>
                <i class="fas fa-phone icon"></i>
                <input type="text" maxlength="10" pattern="\d{10}" oninput="this.value = this.value.replace(/[^0-9]/g,'')" id="phone" name="phone" class="form-control" value="<?= old('phone') ?>">
                <small class="text-danger"><?= session('validation') ? session('validation')->getError('phone') : '' ?></small>
            </div>

            <div class="form-group">
                <label for="subject">Subject</label>
                <i class="fas fa-tag icon"></i>
                <input type="text" id="subject" name="subject" class="form-control" value="<?= old('subject') ?>" required>
                <small class="text-danger"><?= session('validation') ? session('validation')->getError('subject') : '' ?></small>
            </div>

            <div class="form-group">
                <label for="message">Your Message</label>
                <textarea id="message" name="message" class="form-control" required><?= old('message') ?></textarea>
                <small class="text-danger"><?= session('validation') ? session('validation')->getError('message') : '' ?></small>
            </div>
<?php
    // Generate two random numbers for captcha
    $num1 = rand(0, 9);
    $num2 = rand(0, 9);
    $sum = $num1 + $num2;
    session()->set('captcha_sum', $sum);
?>
<div class="form-group">
    <label for="captcha">Enter the Result of <?= $num1 ?> + <?= $num2 ?> = ?</label>
    <i class="fas fa-calculator icon"></i>
    <input type="text" id="captcha" name="captcha" class="form-control" required placeholder="Enter the sum">
    <small class="text-danger">
        <?= session('captcha_error') ? session('captcha_error') : '' ?>
    </small>
</div>



            <button type="submit" class="submit-btn">
                <i class="fas fa-paper-plane"></i> Submit Enquiry
            </button>
        </form>
    </div>
  <script src="<?php echo base_url('public/js/app.v1.js')?>"></script> 
                 <script src="<?php echo base_url('public/js/app.v1.js')?>"></script> 
    
</body>
</html>