<?php namespace App\Models;
 
 use CodeIgniter\Model;
 use App\Controllers\User_Controller;
 use App\Controllers\User_dashboard;
  
 class UserModel extends Model{
     protected $table = 'users';
      protected $primaryKey = 'id';
     protected $allowedFields = [
      'id',
      'referralId',
      'admin_id',
     'manager_id',
     'name',
     'email',
     'DonationPurpose',
     'created_at',
     'password',
     'dob',
     'response_by',
     'father_name',
     'reference_name',
     'mobile',
     'address',
     'district',
     'state',
     'user_type',
     'aadhar_card_no',
     'nationality',
     'designation',
     'level',
     'profile',
     'profile_update',
     'status',
     'payment_amount',
     'trans_name',
     'trans_mobile',
     'transaction_id',
     'payment_pic',
     'payment_status',
     'admin_id',
     'otp',
     'verification_status',
     'response_msg',
     'reason_msg',
     'verifie_date',
     'expire_date',
     'certificate_status',
     'enrollment_no',
     'appointment_date',
     'esic_no',
     'epf_no',
     'namehindi',
     'blood_group',
     'pan_no',
     'mother_name',
     'branch_name',
     'bank_name',
     'ifsc_code',
     'accounts_no',
     'permanent_address',
     'ward_no',
     'tashil',
     'police_station',
     'pin_code',
     'religion',
     'category',
     'gender',
     'married_status',
     'husband_wife_name',
     'married_date',
     'nominee',
     'relation',
     'nominee_dob',
     'terms',
     'dl_no',
     'dl_issue_date',
     'degreeName',
     'division',
     'roll_no',
     'passoutDate',
     'name_1_acquaintances',
     'name_2_acquaintances',
     'work_place',
     'degreeName',
     'roll_no',
     'division',
     'passoutDate',
     'collegeName',
     'son_doughter',
     'vi_aadhar_no',
     'vi_dob',
     'vi_qualification',
     'vi_glood_group',
     'certi_qrcode',
     'transaction_donoate_id',
     'block_date',
     'verifie_by',
     'occupation',
     'amount',
     'last_login',
     'interest',
     'UploadPANCard',
     'UploadAadharCardFront',
     'UploadAadharCardBack',
     'zone_id',
     'state_id',
     'district_id',
     'block_id',
     'panchayat_id',
 ];


// app/Models/UserModel.php
public function checkForExpiredUsers()
{
    $date = date('Y-m-d'); // Get today's date
    $this->db->where('verifie_date =', $date)
             ->where('expire_date =', $date)
             ->set('status', 'block')
             ->update('users');
}


public function getDataByDateRange($startDate, $endDate)
    {
        // Perform a query to retrieve data within the specified date range
        return $this->where('created_at >=', $startDate)
                    ->where('created_at <=', $endDate)
                    ->findAll();
    }
    public function getDataByDateRange_manager($startDate, $endDate)
    {
        // Perform a query to retrieve data within the specified date range
        return $this->where('created_at >=', $startDate)
                    ->where('created_at <=', $endDate)
                    ->where('user_type', "manager")
                    ->findAll();
    }



 }