<?php namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use App\Models\UserModel;
use CodeIgniter\Email\Email;
use CodeIgniter\CLI\CLI;
use CodeIgniter\I18n\Time;
 use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

class BirthdayWishes extends BaseCommand
{
    protected $group       = 'Birthday';
    protected $name        = 'birthday:wishes';
    protected $description = 'Send birthday wishes emails automatically';

    public function run(array $params)
    {
        $today = date('m-d');
        $tomorrow = date('m-d', strtotime('+1 day'));

        $userModel = new UserModel();

        // Today's Birthday
        $todayUsers = $userModel->where("DATE_FORMAT(dob, '%m-%d')", $today)->findAll();
        foreach ($todayUsers as $user) {
            $this->sendBirthdayEmail($user, 'today');
        }

        // Tomorrow's Birthday
        $tomorrowUsers = $userModel->where("DATE_FORMAT(dob, '%m-%d')", $tomorrow)->findAll();
        foreach ($tomorrowUsers as $user) {
            $this->sendBirthdayEmail($user, 'tomorrow');
        }

        CLI::write("Birthday emails sent.");
    }

private function sendBirthdayEmail($user, $type = 'today')
{
   //Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);


    $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

    // Load DB config manually if needed
   require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $result = mysqli_query($connection, "SELECT * FROM email_credentials LIMIT 1");
    $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $resultweb = mysqli_query($connection, "SELECT * FROM admin_website_update LIMIT 1");
    $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);

    try {
        // SMTP Config
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = $email_data['by_email'];
        $mail->Password   = $email_data['by_password'];
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        // Recipients
        $mail->setFrom($email_data['by_email'], $email_data['subject']);
        $mail->addAddress($user['email'], $user['name']);

        // Content
        $mail->isHTML(true);

        if ($type === 'today') {
            $mail->Subject = '🎂 Happy Birthday!';
            $message = view('emails/birthday_today', ['name' => $user['name']]);
        } else {
            $mail->Subject = '🎁 Early Birthday Wishes!';
            $message = view('emails/birthday_tomorrow', ['name' => $user['name']]);
        }

        $mail->Body = $message;

        $mail->send();
        CLI::write("Birthday mail sent to: {$user['email']}");
    } catch (\PHPMailer\PHPMailer\Exception $e) {
        CLI::error("Failed to send to {$user['email']}: {$mail->ErrorInfo}");
    }
}

}
