<?php

use app\ThirdParty\JWT\php_jwt_main\src\JWT;
use app\ThirdParty\JWT\php_jwt_main\src\Key;
if (!function_exists('generate_jwt')) {
    function generate_jwt($payload)
    {
        $key = getenv('JWT_SECRET_KEY');
        if (!$key) {
            throw new \Exception('JWT_SECRET_KEY is not configured');
        }

        $issuedAt = time();
        $expirationTime = $issuedAt + (getenv('JWT_TIME_TO_LIVE') ?: 3600);

        $payload = array_merge($payload, [
            'iat' => $issuedAt,
            'exp' => $expirationTime
        ]);

        return JWT::encode($payload, $key, 'HS256');
    }
}

if (!function_exists('validate_jwt')) {
    function validate_jwt($token)
    {
        try {
            $key = getenv('JWT_SECRET_KEY');
            if (!$key) {
                throw new \Exception('JWT_SECRET_KEY is not configured');
            }

            $decoded = JWT::decode($token, new Key($key, 'HS256'));
            return (array) $decoded;
        } catch (\Exception $e) {
            log_message('error', 'JWT Validation Error: ' . $e->getMessage());
            return false;
        }
    }
}
