<?php
namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class JwtAuth implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        require_once APPPATH . 'ThirdParty/JWT/JWT.php';
        require_once APPPATH . 'ThirdParty/JWT/Key.php';
        require_once APPPATH . 'helpers/jwt_helper.php';

        $authHeader = $request->getHeaderLine('Authorization');
        
        if (empty($authHeader)) {
            return service('response')
                ->setJSON(['error' => 'Token required'])
                ->setStatusCode(401);
        }

        $token = str_replace('Bearer ', '', $authHeader);
        $decoded = validate_jwt($token);

        if (!$decoded) {
            return service('response')
                ->setJSON(['error' => 'Invalid/expired token'])
                ->setStatusCode(403);
        }

        $request->user = $decoded;
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do nothing
    }
}