<?php

namespace App\Controllers;

use App\Libraries\DataEncoder;
use CodeIgniter\Controller;

class MyController extends Controller
{
    protected $encoder;

    public function initController(\CodeIgniter\HTTP\RequestInterface $request, \CodeIgniter\HTTP\ResponseInterface $response, \Psr\Log\LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->encoder = new DataEncoder();
    }

    public function decodeAndRoute($encodedString = null)
    {
        
        if ($encodedString) {
            $decodedData = $this->encoder->decode($encodedString);
            if (isset($decodedData['uri'])) {
                $uri = $decodedData['uri'];
                unset($decodedData['uri']); 
                switch ($uri) {
                    case 'signin':
                        return redirect()->to('/signin'); 
                    case 'Active-Referral-Admin':
                        return (new \App\Controllers\Admin_Controller())->ActiveReferralAdmin();
                    default:
                        echo "Invalid URI";
                        break;
                }
            } else {
              
                $decodedData = base64_decode($encodedString);
                      
                if (isset($decodedData)) {
                    $uri = $decodedData;
                    unset($decodedData);

                    if (strpos($uri, 'admin_refferal_data/') === 0) {
                        // extract the ID
                        $id = str_replace('admin_refferal_data/', '', $uri);
                        return (new \App\Controllers\Admin_Controller())->admin_refferal_data($id);
                    }
                    if (strpos($uri, 'referral_donation_details/') === 0) {
                        // extract the ID
                        $id = str_replace('referral_donation_details/', '', $uri);
                        return (new \App\Controllers\Admin_Controller())->referral_donation_details($id);
                    }
                    
                    if (strpos($uri, 'donate_receipt_download/') === 0) {
                        // extract the ID
                        $id = str_replace('donate_receipt_download/', '', $uri);
                        return (new \App\Controllers\Home())->donate_receipt_download($id);
                    }
  
                    switch ($uri) {
                      
                        case 'Donate-My-Referal':
                            return (new \App\Controllers\User_Controller())->Donate_My_Referal();
                        case 'admin_generate_poster':
                            return (new \App\Controllers\Admin_Controller())->admin_generate_poster();
                        case 'admin_referral_donation':
                            return (new \App\Controllers\Admin_Controller())->admin_referral_donation();
                        case 'admin_show_inactive_user':
                            return (new \App\Controllers\Admin_Controller())->admin_show_inactive_user();
                        case 'admin_show_verifie_user':
                            return (new \App\Controllers\Admin_Controller())->admin_show_verifie_user();
                        case 'admin_by_certificate_generate':
                            return (new \App\Controllers\Admin_Controller())->admin_by_certificate_generate();
                        case 'admin_by_certificate_generate_id':
                            return (new \App\Controllers\Admin_Controller())->admin_by_certificate_generate_id();
                        case 'coming_expire_member':
                            return (new \App\Controllers\Admin_Controller())->coming_expire_member();
                        case 'expire_member':
                            return (new \App\Controllers\Admin_Controller())->expire_member();
                        case 'Active-Referral-Admin':
                            return (new \App\Controllers\Admin_Controller())->ActiveReferralAdmin();
                        case 'Inactive-Referral-Admin':
                            return (new \App\Controllers\Admin_Controller())->InactiveReferralAdmin();
                        default:
                           
                            list($ddurl, $code) = explode('_', $uri);
                            if ($ddurl && strpos($ddurl, '/') == true) {
                                 list($url, $id) = explode('/', $ddurl);
                                
                            
                                switch ($url) {
                                    
                                 case 'Donate-My-Referal':
                                        return (new \App\Controllers\User_Controller())->Donate_My_Referal();
                                    case 'admin_generate_poster':
                                        return (new \App\Controllers\Admin_Controller())->admin_generate_poster();
                                    case 'admin_referral_donation':
                                        return (new \App\Controllers\Admin_Controller())->admin_referral_donation();
                                    case 'admin_show_inactive_user':
                                        return (new \App\Controllers\Admin_Controller())->admin_show_inactive_user();
                                    case 'admin_show_verifie_user':
                                        return (new \App\Controllers\Admin_Controller())->admin_show_verifie_user();
                                    case 'admin_by_certificate_generate':
                                        return (new \App\Controllers\Admin_Controller())->admin_by_certificate_generate();
                                    case 'admin_by_certificate_generate_id':
                                        return (new \App\Controllers\Admin_Controller())->admin_by_certificate_generate_id();
                                    case 'coming_expire_member':
                                        return (new \App\Controllers\Admin_Controller())->coming_expire_member();
                                    case 'expire_member':
                                        return (new \App\Controllers\Admin_Controller())->expire_member();
                                    case 'Active-Referral-Admin':
                                        return (new \App\Controllers\Admin_Controller())->ActiveReferralAdmin();
                                    case 'Inactive-Referral-Admin':
                                        return (new \App\Controllers\Admin_Controller())->InactiveReferralAdmin();
                                    case 'adminReferralDonation':
                                        return (new \App\Controllers\Admin_Controller())->adminReferralDonation($id);
                                        
                                        case 'profile':
                            return (new \App\Controllers\User_dashboard())->profile($id);
                             case 'membershipStatus':
                            return (new \App\Controllers\User_dashboard())->membershipStatus($id);
                            
                                }
                            }else{
                               
                                switch ($ddurl) {
                            
                             case 'adminAddOccupation':
                            return (new \App\Controllers\Admin_Controller())->adminAddOccupation();
                                     case 'adminShowInactiveUser':
                            return (new \App\Controllers\Admin_Controller())->admin_show_inactive_user();
                            case 'adminShowVerifieUser':
                            return (new \App\Controllers\Admin_Controller())->admin_show_verifie_user();
                            case 'adminShowBlockUser':
                            return (new \App\Controllers\Admin_Controller())->admin_show_block_user();
                            case 'userShowByAdmin':
                            return (new \App\Controllers\Admin_Controller())->user_show_by_admin();
                            
                            case 'userDashboard':
                            return (new \App\Controllers\User_dashboard())->user_dashboard();
                       
                       
                                }
                                break;
                                echo "Invalid URL";
                                
                            }
                            break;
                            echo "Invalid URL";
                    }
                    
                     return (new \App\Controllers\Home())->signin();
                } else {
                    echo "URL Not Found!";
                }
            }
        } else {
            echo "Connection Not Found";
        }
    }

    public function signin()
    {
        echo "View Page ";
    }
}