<?php

namespace App\Controllers\Admin;
namespace App\Controllers\Location;
use App\Controllers\BaseController;
use App\Models\StateModel;
use App\Models\ZoneModel;

class StateController extends BaseController
{
    public function index()
    {
        $model = new StateModel();

        $data['states'] = $model
            ->select('states.*, zones.name as zone_name')
            ->join('zones', 'zones.id = states.zone_id')
            ->orderBy('states.id', 'DESC')
            ->findAll();

        return view('admin_dashboard/states/index', $data);
    }

    public function create()
    {   
        $data['heading']="Add State";
        $data['state'] = null;
        $data['zones'] = (new ZoneModel())->orderBy('name')->findAll();
        return view('admin_dashboard/states/create', $data);
    }

    public function store()
    {
        $rules = [
            'zone_id' => 'required',
            'name'    => 'required|min_length[2]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->with('error', 'Validation Failed')->withInput();
        }

        (new StateModel())->save([
            'zone_id' => $this->request->getPost('zone_id'),
            'name'    => $this->request->getPost('name'),
        ]);

        return redirect()->to('states')->with('success', 'State Created Successfully');
    }

    public function edit($id)
    {
        $model = new StateModel();
        $data['heading']="Update State";
        $data['state'] = $model->find($id);
        $data['zones'] = (new ZoneModel())->findAll();

        return view('admin_dashboard/states/create', $data);
    }

    public function updatestate($id)
    {
        $rules = [
            'zone_id' => 'required',
            'name'    => 'required|min_length[2]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->with('error', 'Validation Failed')->withInput();
        }

        (new StateModel())->update($id, [
            'zone_id' => $this->request->getPost('zone_id'),
            'name'    => $this->request->getPost('name'),
        ]);

        return redirect()->to('states')->with('success', 'State Updated Successfully');
    }

    public function delete($id)
    {
        (new StateModel())->delete($id);

        return redirect()->to('/admin/states')->with('success', 'State Deleted Successfully');
    }
}
