<?php

namespace App\Controllers\Admin;
namespace App\Controllers\Location;
use App\Controllers\BaseController;
use App\Models\BlockModel;
use App\Models\DistrictModel;

class BlockController extends BaseController
{
    public function index()
    {
        $data['blocks'] = (new BlockModel())
            ->select('blocks.*, districts.name as district_name')
            ->join('districts', 'districts.id = blocks.district_id')
            ->orderBy('blocks.id', 'DESC')
            ->findAll();

        return view('admin_dashboard/blocks/index', $data);
    }

public function create()
{
    $data['heading'] = "Add Block";
    $data['block'] = null; // Important
    $data['districts'] = (new DistrictModel())->findAll();

    return view('admin_dashboard/blocks/create', $data);
}

public function store()
{
    $rules = [
        'district_id' => 'required',
        'name'        => 'required|min_length[2]'
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->with('error', 'Validation Failed')->withInput();
    }

    (new BlockModel())->save([
        'district_id' => $this->request->getPost('district_id'),
        'name'        => $this->request->getPost('name'),
    ]);

    return redirect()->to('blocks')->with('success', 'Block Created Successfully');
}

public function edit($id)
{
    $model = new BlockModel();

    $data['heading'] = "Update Block";
    $data['block'] = $model->find($id);         // Load block data
    $data['districts'] = (new DistrictModel())->findAll();

    return view('admin_dashboard/blocks/create', $data);
}

public function blocksUpdate($id)
{
    $rules = [
        'district_id' => 'required',
        'name'        => 'required|min_length[2]'
    ];

    if (!$this->validate($rules)) {
        return redirect()->back()->with('error', 'Validation Failed')->withInput();
    }

    (new BlockModel())->update($id, [
        'district_id' => $this->request->getPost('district_id'),
        'name'        => $this->request->getPost('name'),
    ]);

    return redirect()->to('blocks')->with('success', 'Block Updated Successfully');
}


    public function delete($id)
    {
        (new BlockModel())->delete($id);

        return redirect()->to('blocks')->with('success', 'Block Deleted Successfully');
    }
}
