<?php

namespace App\Controllers\Location;

use App\Controllers\BaseController;
use App\Models\StateModel;
use App\Models\DistrictModel;
use App\Models\BlockModel;
use App\Models\PanchayatModel;

class AjaxLocationController extends BaseController
{
    public function states($zoneId)
    {
        $model = new StateModel();
        return $this->response->setJSON($model->where('zone_id', $zoneId)->findAll());
    }

    public function districts($stateId)
    {
        $model = new DistrictModel();
        return $this->response->setJSON($model->where('state_id', $stateId)->findAll());
    }

    public function blocks($districtId)
    {
        $model = new BlockModel();
        return $this->response->setJSON($model->where('district_id', $districtId)->findAll());
    }

    public function panchayats($blockId)
    {
        $model = new PanchayatModel();
        return $this->response->setJSON($model->where('block_id', $blockId)->findAll());
    }
}
