<?php namespace App\Commands;

use CodeIgniter\CLI\BaseCommand;
use CodeIgniter\CLI\CLI;
use App\Models\UserModel;

class AutoDeactivateUsers extends BaseCommand
{
    protected $group = 'Tasks';
    protected $name = 'deactivate:users';
    protected $description = 'Deactivate users whose verification has expired';

    public function run(array $params)
    {
        $userModel = new UserModel();
        
        // Find active users whose expire_date has passed
        $users = $userModel->where('status', 'active')
                          ->where('expire_date <', date('Y-m-d H:i:s'))
                          ->findAll();

        if (!empty($users)) {
            foreach ($users as $user) {
                $userModel->update($user['id'], ['status' => 'inactive']);
                log_message('info', "User {$user['id']} deactivated (Expired: {$user['expire_date']})");
            }
            
            CLI::write(count($users) . ' users deactivated.', 'green');
        } else {
            CLI::write('No users to deactivate.', 'yellow');
        }
    }
}