<!DOCTYPE html>
<html lang="en">
<head>
  <title>Payment Processing</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <style>
    * {
      font-family: 'Poppins', sans-serif;
    }
    .main_box {
      width: 100%;
      padding-bottom: 60px;
      padding-top: 25px;
      box-shadow: rgba(0, 0, 0, 0.15) 0px 15px 25px, rgba(0, 0, 0, 0.05) 0px 5px 10px;
      border-radius: 10px;
      background: rgb(65 88 110) !important;
    }
    .container {
      width:100%;
      max-width:1200px;
      margin:auto;
    }
    .id_lable {
      color:white !important;
      font-size: 14px !important;
      display: flex;
    }
    .razorpay-payment-button {
      display: flex !important;
      margin: auto !important;
      transform: translateY(-60px);
      padding: 6px 10px !important;
      border-radius: 4px;
      border: none;
      background:#89cc97;
      color: white;
      font-size: 16px;
    }
    .processing-ui {
      text-align: center;
      padding: 20px;
      margin: 20px 0;
      background: rgba(0,0,0,0.1);
      border-radius: 8px;
      display: none;
    }
    .spinner {
      width: 50px;
      height: 50px;
      border: 5px solid rgba(255,255,255,0.3);
      border-top: 5px solid #fff;
      border-radius: 50%;
      animation: spin 1s linear infinite;
      margin: 0 auto 15px;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }
    .status-text {
      color: white;
      font-size: 18px;
      margin-top: 10px;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      border: 2px solid #fff;
      margin-bottom:20px;
    }
    th, td {
      padding: 5px;
      text-align: left;
      border-bottom: 2px solid #fff;
      border-left: 2px solid #fff;
    }
    .refresh {
      font-size:22px;
      margin-top:0px;
      color: #ffffff;
      text-shadow: 0px 4px 2px black;
    }
    .hidden {
      display: none !important;
    }
  </style>
</head>
<body>
<div class="container">
  <div class="row">
    <div class="col-xl-3 col-lg-3 col-md-3"></div>
    <div class="col-xl-6 col-lg-6 col-md-6">
      <div class="panel" style="margin-top: 60px !important; background:#89cc97;">
        <?php 
          require 'db_config.php';
          $queryli = "SELECT * FROM `admin_website_update`";
          $result = mysqli_query($connection, $queryli);
          $datamsg = mysqli_fetch_array($result, MYSQLI_ASSOC);
          $description = $datamsg['web_name'];
        ?>
        
        <div class="panel-heading text-center" style="font-size: 20px !important;">
          <span class="Uddeshiy" style="text-transform: capitalize;"><?php echo $datamsg['web_name']?></span>
        </div>
        
        <div class="panel-body" style="background:#374b5e !important;">
          <div style="text-align: center;">
            <h3 class="refresh" id="statusMessage">
              <?php echo isset($_GET['payment_status']) ? 'Payment Completed' : 'Ready for Payment'; ?>
            </h3>
            
            <!-- Processing UI -->
            <div class="processing-ui" id="processingUI">
              <div class="spinner"></div>
              <div class="status-text">Processing your payment...</div>
              <p style="color: #ccc;">Please wait, do not refresh or go back</p>
            </div>
            
            <div class="row">
              <div class="col-xl-1 col-lg-1 col-md-1"></div>
              <div class="col-xl-10 col-lg-10 col-md-10">
                <div class="main_box">
                  <div class="container">
                    <table>
                      <tr>
                        <td><label class="id_lable">User ID:</label></td>
                        <td><label class="id_lable"><?php echo $users['id'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Name:</label></td>
                        <td><label class="id_lable"><?php echo $users['user_name'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Email:</label></td>
                        <td><label class="id_lable"><?php echo $users['email'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Mobile No:</label></td>
                        <td><label class="id_lable"><?php echo $users['mobile'];?></label></td>
                      </tr>
                      <tr>
                        <td><label class="id_lable">Amount:</label></td>
                        <td><label class="id_lable">₹<?php echo $users['amount'];?></label></td>
                      </tr>
                    </table>
                  </div>
                </div>
              </div>
              <div class="col-xl-1 col-lg-1 col-md-1"></div>
            </div>
          </div>

          <?php if (session()->has('error')) { ?>
            <div class="alert alert-danger alert-dismissible fade in" role="alert">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">×</span>
              </button>
              <strong>Error!</strong> <?=session("error")?>
            </div>
          <?php } ?>

          <?php if (!isset($_GET['payment_status'])): ?>
            <form action="<?=base_url('vistordonatepayment')?>" method="POST" id="paymentForm">
              <script src="https://checkout.razorpay.com/v1/checkout.js"
                data-key="<?=env('razorKey')?>"
                data-amount="<?php echo $amount*100;?>"
                data-buttontext="Pay ₹<?php echo $amount;?>"
                data-order_id="<?php echo $order_id;?>"
                data-name="<?php echo $datamsg['web_name']?>"
                data-description="<?php echo $description?>"
                data-image="<?php echo base_url('websiteLogoImages/'.$datamsg['web_logo'])?>"
                data-prefill.name="<?php echo $users['user_name'];?>"
                data-prefill.email="<?php echo $users['email'];?>"
                data-prefill.branch_name="<?php echo $users['branch_name'];?>"
                data-prefill.user_id="<?php echo $users['id'];?>"
                data-notes.trans_bank="<?php echo $users['bank_name'];?>"
                data-notes.trans_pan_no="<?php echo $users['pan_no'];?>"
                data-notes.trans_mobile="<?php echo $users['mobile'];?>"
                data-notes.user_id="<?php echo $users['id'];?>"
                data-theme.color="#ff7529"
                data-callback="handlePaymentResponse">
                
              </script>
              <input type="hidden" name="user_id" value="<?= $users['id'] ?>">
            </form>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="col-xl-3 col-lg-3 col-md-3"></div>
  </div>
</div>

<script>
  $(document).ready(function() {
    // Check if payment is already completed
    if(window.location.search.includes('payment_status')) {
      $('#paymentForm').addClass('hidden');
      $('#statusMessage').text('Payment Completed');
      return;
    }

    // Auto-trigger payment after short delay
    setTimeout(function() {
      $('.razorpay-payment-button').click();
    }, 500);
  });

  // Handle Razorpay payment response
  function handlePaymentResponse(response) {
    // Hide payment button and show processing UI
    $('#paymentForm').addClass('hidden');
    $('#processingUI').show();
    $('#statusMessage').text('Payment in Progress');
    
    // Extract payment details from response
    var paymentId = response.razorpay_payment_id;
    var orderId = response.razorpay_order_id;
    var signature = response.razorpay_signature;
    
    // Verify payment on server side
    $.ajax({
      url: '<?=base_url('verify_payment')?>',
      type: 'POST',
      data: {
        payment_id: paymentId,
        order_id: orderId,
        signature: signature
      },
      success: function(serverResponse) {
        if(serverResponse.success) {
          // Payment verification successful
          $('#processingUI .status-text').text('Payment Successful!');
          setTimeout(function() {
            window.location.href = window.location.href + '?payment_status=success';
          }, 2000);
        } else {
          // Payment verification failed
          $('#processingUI .status-text').text('Payment Verification Failed');
          $('#processingUI').css('background', 'rgba(255,0,0,0.1)');
        }
      },
      error: function() {
        // Error in verification
        $('#processingUI .status-text').text('Error verifying payment');
        $('#processingUI').css('background', 'rgba(255,0,0,0.1)');
      }
    });
  }
</script>
</body>
</html>