<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head><meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
  
  <title>Member Receipt</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <link rel="stylesheet" href="<?php echo base_url('public/css/visitor_donate_receipt.css')?>">
  <script src="<?php echo base_url('public/qrcode.min.js')?>"></script>
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://rawgit.com/eKoopmans/html2pdf/master/dist/html2pdf.bundle.js"></script>
    
<style>
@media (max-width: 600px) {
     
   .logo {
        width: 113px;
        margin-top: -7px;
    }
}
    
.watermark {
    /*position: fixed;*/
    opacity: 0.2;
    font-size: 80px;
    width: 100%;
    text-align: center;
    z-index: 1000;
    transform: rotate(-45deg);
    transform-origin: 50% 50%;
    pointer-events: none;
    top: 50%;
    left: 0;
    font-weight: bold;
    color: red;
}
    
.watermark.paid {
    color: green;
}
    
.watermark.failed {
     color: red;
}
    
.fail-message {
    display: none;
    background-color: #ffebee;
    color: #d32f2f;
    padding: 10px;
    margin: 10px 0;
    border-radius: 4px;
    text-align: center;
    font-weight: bold;
}

.receipt-wrapper{
    position: relative;
}

.watermark_image{
    position:absolute;
}

.logo2{
   width: 250px;
    height: 250px;
    margin-top: -68px;
    opacity: 0.04;
}
    
  </style>
</head>
<body style="margin:0;">
    
<div class="background_color">
    <div class="body1" id="content-to-print">
  <div class="receipt-wrapper">
       <div class="watermark" id="watermark" style="<?php echo ($payments['trans_status'] == 'fail' || $payments['trans_status'] == 'PAYMENT_PENDING') ? 'display:block;' : 'display:none;'; ?>">FAILED</div>

    <div class="fail-message" id="failMessage" style="<?php echo ($payments['trans_status'] == 'fail' || $payments['trans_status'] == 'PAYMENT_PENDING') ? 'display:block;' : 'display:none;'; ?>">
      This transaction has failed. Please contact support if amount is deducted.
    </div>



    <div class="header">
      <div>
        <p style="width: 159px; padding: 6px; font-weight: 600; background: #f2f2f2;">
          <i class="fa-solid fa-receipt"></i> Membership Receipt
        </p>
      </div>

      <div class="logo_box">
        <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" alt="logo" class="logo">
        <div class="line"></div>
      </div>
      <h2><?php echo $dataweb['web_name']?></h2>
      <p><b>Registration Number:</b> <?php echo $dataweb['ngo_id']?></p>
      <p><b>Niti Aayog Reg No:</b> <?php echo $dataweb['niti_id']?> | <b>80G Reg No:</b> <?php echo $dataweb['80G_id']?> | <b>12A Reg No:</b> <?php echo $dataweb['12a_id']?> | <b>PAN No:</b> <?php echo $dataweb['pan_no']?></p>
      <p><i class="fas fa-map-marker-alt icon"></i> <?php echo $dataweb['website_address']?></p>
      <p><i class="fas fa-phone icon"></i> <?php echo $dataweb['site_mobile_1']?> | <i class="fas fa-envelope icon"></i> <?php echo $dataweb['webemail_1']?> | <i class="fas fa-globe icon"></i> www.<?php echo $dataweb['site_url']?></p>
    </div>

    <div class="receipt-no">Receipt No: <?php 
      if($payments['user_id']=="visitor") { 
        echo "VD/RCP-";
      } else { 
        if($payments['user_id']=="cash") {
          echo "CD/RCP-";
        } else { 
          echo "M/RCP-";
        } 
      } 
      echo $payments['id']?>
    </div>

    <table class="details-table">
      <tr><th colspan="2"><i class="fas fa-user icon"></i> Member Information</th></tr>
      <tr><td width="30%"><b>Full Name</b></td><td><?php echo $payments['user_name']?></td></tr>
      <tr><td><b>Address</b></td><td><?php echo $users['address']?></td></tr>
      <?php if($users['pan_no']){?>
      <tr><td><b>PAN Number</b></td><td><?php echo $users['pan_no']?></td></tr>
      <?php } ?>
    </table>

    <div style="display:flex; justify-content:center;">
        <div class="watermark_image">
            <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" alt="logo" class="logo2">
        </div>
    </div>

    <table class="details-table">
      <tr><th colspan="2"><i class="fas fa-hand-holding-heart icon"></i> Fee Details</th></tr>
      <tr><td><b>Amount</b></td><td><?php echo $payments['amount']?> <span class="amount-in-words">(<?php echo $datarecipt['formatteword'];?> Rupees Only)</span></td></tr>
      <tr><td><b>Payment Mode</b></td><td><i class="fas fa-mobile-alt icon"></i> Online (Txn ID: <?php echo ($payments['providerReferenceId']=="admin") ? "Cash" : $users['transaction_id'] ?>)</td></tr>
      <tr><td><b>Date</b></td><td><i class="far fa-calendar-alt icon"></i> <?php echo $datarecipt['formattedDate']; ?></td></tr>
      <?php if($users['DonationPurpose']){?>
      <tr><td><b>Purpose</b></td><td><i class="fas fa-book icon"></i> <?php echo $users['DonationPurpose']?></td></tr>
      <?php }?>
      <tr><td><b>Status</b></td>
        <td><?php if($payments['trans_status']=="PAYMENT_PENDING" || $payments['trans_status']=="fail" || $payments['trans_status']=="PAYMENT_FAILD"){ ?>
          <strong style="color:red;">Fail</strong>
          <?php } else { ?>
             <strong style="color:green;">Success</strong>
          <?php } ?>
        </td>
      </tr>
    </table>

    <div class="qr-signature-section">
      <div class="qr-code">
        <p><strong>Scan QR for Verification</strong></p>
        <div class="member_qr_box">
          <div id="qrcoder"></div>
        </div>
      </div>
      <div class="signature-block">
        <label for="" style="padding: 3px 20px; border-bottom: 1px solid grey;">
          <img src="<?php echo base_url('certificateProviderSignature/'.$dataweb['certificate_provider_signature'])?>" alt="logo" class="logo" style="transform: translate(0px, 7px);">
        </label>
        <p><strong><?php echo $dataweb['certificate_provider_name']?><br>(<?php echo $dataweb['designation']?>)</strong></p>
        <p>Authorised Signatory</p>
        <p><i class="fas fa-stamp icon"></i> <?php echo $dataweb['web_name']?></p>
      </div>
    </div>

    <div class="footer-info">
          <?php if($users['pan_no']){?>
      <p><i class="fas fa-info-circle icon"></i> This donation is eligible for 50% tax deduction under Section 80G of Income Tax Act, 1961 </p>
      <?php }?>
    
      <p><strong>Thank you for your generous support !</strong></p>
    </div>
  </div>
</div>

<!-- Download Button -->
<div class="main_btn_box">
    <?php 
    $session = session();

    if ($session->type == "payu" && $session->id) { ?>
        <a class="download_btn" href="<?= base_url('signin') ?>" style="text-decoration:none; color:white;"><i class="fa-solid fa-angle-left" style="padding-right: 5px;"></i> 
            Go Back
        </a>

    <?php } elseif ($session->id) { ?>
        <button class="download-btn" onclick="history.back()">
            <i class="fa-solid fa-chevron-left"></i> Go Back
        </button>

    <?php } elseif ($session->user_id == "visitor") { ?>
        <a class="download_btn" href="<?= base_url('signin') ?>" style="text-decoration:none; color:white;">
            Go Back
        </a>

    <?php } else { ?>
        <button class="download_btn download-btn" onclick="history.back()">Go Back</button>
    <?php } ?>

    <button class="download-btn" onclick="window.print()">
        <i class="fas fa-download"></i> Download PDF
    </button>
</div>


</div>

<script>
  // Generate QR Code
  var content = "<?php echo base_url('membership_receipt_download/'.$users['transaction_id']) ?>";
  var qrcoder = new QRCode(document.getElementById("qrcoder"), {
    text: content,
    width: 90,
    height: 90,
  });

  // Handle print event to possibly adjust styles before printing
  window.onbeforeprint = function() {
    // You can adjust styles here if needed before printing
  };
</script>

</body>
</html>