<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Status Notification</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        
        .popup-container {
            width: 100%;
            max-width: 500px;
            background: white;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
            animation: popIn 0.5s ease-out forwards;
            transform-origin: center;
            margin-top: 20px;
        }
        
        .popup-header {
            background: linear-gradient(to right, #ff6b6b, #ff8e8e);
            color: white;
            padding: 15px 30px;
            text-align: center;
            position: relative;
        }
        
        .icon-container {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0 auto;
            font-size: 36px;
            border: 3px solid white;
        }
        
        .popup-header h1 {
            font-size: 24px;
            font-weight: 600;
            margin: 8px 0px 0px 0px;
        }
        
        .popup-body {
            padding: 15px;
        }
        
        .status-card {
            background: #f9f9f9;
            border-radius: 12px;
            padding: 20px;
            border-left: 5px solid #ff6b6b;
        }
        
        .status-item {
            display: flex;
            margin-bottom: 15px;
            border-bottom: 1px dashed #eee;
        }
        
        .status-item:last-child {
            margin-bottom: 0;
            padding-bottom: 0;
            border-bottom: none;
        }
        
        .status-icon {
            width: 40px;
            height: 40px;
            background: #ffeaea;
            border-radius: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin-right: 15px;
            color: #ff6b6b;
            font-size: 18px;
        }
        
        .status-content h3 {
            font-size: 16px;
            color: #777;
            margin-bottom: 5px;
            font-weight: 500;
            text-align: start;
            margin:0;
        }
        
        .status-content p {
            font-size: 18px;
            color: #333;
            font-weight: 600;
            text-align: start;
        }
        
        .reason-box {
            background: #fff4f4;
            border-radius: 10px;
            padding: 0px 20px;
            margin: 12px 0;
            border: 1px solid #ffd6d6;
        }
        
        .reason-box h3 {
            display: flex;
            align-items: center;
            font-size: 18px;
            color: #ff6b6b;
            margin-bottom: 10px;
        }
        
        .reason-box h3 i {
            margin-right: 10px;
        }
        
.reason-box p {
    color: #666;
    line-height: 1.5;
    text-align: start;
        }
        
        .action-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 30px;
        }
        
.button {
    padding: 10px;
    border-radius: 10px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
        
        .btn-primary {
            background: #4e73df;
            color: white;
            border: none;
        }
        
        .btn-primary:hover {
            background: #3a56c4;
            transform: translateY(-2px);
        }
        
.btn-secondary {
    background: white;
    color: #ff8989;
    border: 2px solid #ffd6d6;
    width: 100%;
}
        
        .btn-secondary:hover {
            background: #f5f7ff;
            transform: translateY(-2px);
        }
        
        .support-note {
            text-align: center;
            margin-top: 25px;
            color: #777;
            font-size: 14px;
        }
        
        .support-note a {
            color: #4e73df;
            text-decoration: none;
            font-weight: 500;
        }
        
        @keyframes popIn {
            0% {
                opacity: 0;
                transform: scale(0.8) translateY(20px);
            }
            100% {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }
        
@media (max-width: 576px) {
    .popup-container {
        margin-top: 104px;
        margin-bottom: 131px;
        margin-left: 6px;
        margin-right: 6px;
        width: 97%;
    }
            
            .popup-header {
                padding: 20px;
            }
            
            .popup-body {
                padding: 10px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
        .icon-container {
            width: 70px;
            height: 70px;    
        }
        
.popup-header h1 {
    font-size: 18px !important;
}

.status-content p {
    font-size: 12px;
    
}

.status-content h3 {
    font-size: 12px;
    
}

.status-card {
    padding: 10px !important;
    
}

.reason-box {
    margin: 5px 0;
}
    
}
    </style>
</head>
<body>
    <div class="popup-container">
        <div class="popup-header">
            <div class="icon-container">
                <i class="fas fa-exclamation-triangle" style="font-size: 30px;"></i>
            </div>
            <h1>Account Status</h1>
        </div>
        
        <div class="popup-body">
            <div class="status-card">
                <div class="status-item">
                    <div class="status-icon">
                        <i class="fas fa-user-circle"></i>
                    </div>
                    <div class="status-content">
                        <h3>Account Status</h3>
                        <p>Temporary Suspended</p>
                    </div>
                </div>
                
                <div class="status-item">
                    <div class="status-icon">
                        <i class="fas fa-ban"></i>
                    </div>
                    <div class="status-content">
                        <h3>Profile Status</h3>
                        <p><?php echo ucfirst($users['status'])?></p>
                    </div>
                </div>
                
                <div class="status-item">
                    <div class="status-icon">
                        <i class="fas fa-user-shield"></i>
                    </div>
                    <div class="status-content">
                        <h3>Response By</h3>
                        <p><?php echo ucfirst($users['response_by'])?></p>
                    </div>
                </div>
            </div>
            
            <div class="reason-box">
                <h3><i class="fas fa-info-circle"></i> Suspension Reason</h3>
                <p><?php echo ucfirst($users['response_msg'])?></p>
            </div>
            
            <!--<div class="action-buttons">-->
            <!--    <button class="button btn-primary">-->
            <!--        <i class="fas fa-redo-alt"></i> Update Information-->
            <!--    </button>-->
                
                    <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: #ff6b6b;
    padding-left: 20px;
    text-decoration: none;">
                        <button class="button btn-secondary">
    <i class="fas fa-headset"></i> Contact Support
    </button>
</a>
                
            <!--</div>-->

        </div>
    </div>

    <script>
        // Simple animation on button hover
        document.querySelectorAll('.button').forEach(button => {
            button.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-2px)';
                this.style.boxShadow = '0 6px 12px rgba(0,0,0,0.1)';
            });
            
            button.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
                this.style.boxShadow = 'none';
            });
        });
    </script>
</body>
</html>