<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Happy Birthday!</title>
  <style>
    @keyframes confetti {
      0% { transform: translateY(-20px); opacity: 0; }
      100% { transform: translateY(0); opacity: 1; }
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #fef7f1;
      padding: 20px;
      color: #444;
    }

    .container {
      max-width: 600px;
      margin: auto;
      background: #fff8e1;
      border: 2px dashed #ff9800;
      border-radius: 16px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
      padding: 30px;
      animation: confetti 1s ease-in;
    }

    .header {
      text-align: center;
      padding-bottom: 10px;
    }

    .header h1 {
      color: #ff5722;
      font-size: 32px;
    }

    .cake-emoji {
      font-size: 48px;
      margin-bottom: 10px;
    }

    .message {
      font-size: 18px;
      line-height: 1.6;
      margin-top: 20px;
      text-align: center;
    }

    .btn {
      display: inline-block;
      margin-top: 25px;
      padding: 12px 24px;
      background: #ff9800;
      color: #fff;
      text-decoration: none;
      border-radius: 30px;
      transition: background 0.3s ease;
    }

    .btn:hover {
      background: #f57c00;
    }

    .footer {
      margin-top: 30px;
      text-align: center;
      font-size: 14px;
      color: #999;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <div class="cake-emoji">🎂</div>
      <h1>Happy Birthday, <?= esc($name) ?>! 🎉</h1>
    </div>
    <div class="message">
      <p>We hope your day is filled with joy, laughter, and unforgettable memories.</p>
      <p>Wishing you a successful and healthy year ahead! 🌟</p>
    </div>
    <div style="text-align: center;">
      <a href="<?= base_url() ?>" class="btn">Visit Us &raquo;</a>
    </div>
    <div class="footer">
      Sent with ❤️ from <?= esc($site_name ?? 'Your Team') ?>
    </div>
  </div>
</body>
</html>
