
 <?php
               
               $session = session();
               $admin_id = $session->admin_id;
                        require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Healthcare Beneficiary Profile</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="<?php echo base_url('public/css/popup.css')?>" type="text/css" />
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', system-ui, sans-serif;
        }
        
.popup-container {
    width: 920px;
    background: white;
    border-radius: 16px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    overflow: hidden;
    animation: fadeIn 0.4s ease-out;
    margin: 30px auto;
}
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .popup-header {
            /*background: linear-gradient(135deg, #d84b37 0%, #d84b379c 100%);*/
            background-color: #f5f5f5;
            /*color: white;*/
            padding: 25px 30px;
            display: flex;
            align-items: center;
            position: relative;
            gap:20px;
        }
        
        .profile-photo-container {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            overflow: hidden;
            border: 4px solid rgba(255, 255, 255, 0.3);
            background: #e3f2fd;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 25px;
            flex-shrink: 0;
        }
        
.profile-photo {
    width: 100px;
    height: 100px;
    color: #1a6fd9;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    border-radius: 50%;
    text-align: center;
    /* padding: 5px; */
    border: 4px solid white;
}

.profile-photo img{
   width: 100%;
   height: 100%;
   border-radius: 50%;
}
        
        .profile-info {
            flex: 1;
        }
        
        .profile-name {
            font-size: 26px;
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .profile-category {
            font-size: 16px;
            opacity: 0.9;
            margin-bottom: 10px;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 5px 15px;
            background: #086b64;
            border-radius: 20px;
            color:white;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .status-badge i {
            margin-right: 6px;
            font-size: 12px;
        }
        
        .close-btn {
            position: absolute;
            top: 20px;
            right: 20px;
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .close-btn:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: rotate(90deg);
        }
        
        .popup-body {
            padding: 30px;
        }
        
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .info-card {
            background: #f8fafc;
            border-radius: 12px;
            padding: 20px;
            border-left: 4px solid #086b64;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .info-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        }
        
        .card-title {
            font-size: 18px;
            font-weight: 600;
            color: #086b64;
            margin-bottom: 18px;
            display: flex;
            align-items: center;
        }
        
        .card-title i {
            margin-right: 10px;
            font-size: 16px;
        }
        
        .info-item {
            display: flex;
            margin-bottom: 14px;
            padding-bottom: 14px;
            border-bottom: 1px solid #eaeef2;
        }
        
        .info-item:last-child {
            margin-bottom: 0;
            padding-bottom: 0;
            border-bottom: none;
        }
        
        .info-label {
            font-weight: 600;
            width: 140px;
            /*color: #4a5568;*/
            flex-shrink: 0;
        }
        
        .info-value {
            /*color: #2d3748;*/
            flex: 1;
        }
        
        .id-proof-section {
            margin-top: 30px;
        }
        
        .section-title {
            font-size: 20px;
            font-weight: 600;
            color: #086b64;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }
        
        .section-title i {
            margin-right: 10px;
        }
        
        .id-proof-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        
        .id-proof-card {
            background: #f8fafc;
            border-radius: 12px;
            padding: 20px;
            text-align: center;
            transition: transform 0.3s ease;
            border: 1px solid #eaeef2;
        }
        
        .id-proof-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
        }
        
        .id-proof-image {
            width: 100%;
            height: 160px;
            background: linear-gradient(135deg, #e3f2fd 0%, #f0f7ff 100%);
            border-radius: 8px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #4a5568;
            font-size: 14px;
            border: 1px dashed #cbd5e0;
        }
        
        .id-proof-label {
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 5px;
        }
        
        .id-proof-type {
            color: #718096;
            font-size: 14px;
        }
        
        .remark-section {
            margin-top: 30px;
            background: #f8fafc;
            border-radius: 12px;
            padding: 20px;
            border-left: 4px solid #086b64;
        }
        
        .remark-content {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-top: 10px;
            color: #4a5568;
            border: 1px solid #eaeef2;
        }
.id-proof-card{
    display: flex;
    flex-direction: column;
}       

.document_img{
    width: 150px;
    height: 150px;
    background: white;
    margin: auto;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 15px;
    padding: 4px;
    margin-top: 15px;
}

.document_img img{
    width:100%;
    height:100%;
}  

.go_back{
    margin: auto;
    display: flex;
    margin-bottom: 30px;
    padding: 8px 62px;
    font-size: 17px;
    border-radius: 5px;
    border: none;
    cursor: pointer;
}
        
        @media (max-width: 768px) {
            .popup-header {
                flex-direction: column;
                text-align: center;
                padding: 20px;
            }
            
            .profile-photo-container {
                margin-right: 0;
                margin-bottom: 15px;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
            }
            
            .id-proof-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media (max-width: 480px) {
            .popup-body {
                padding: 20px;
            }
            
            .info-item {
                flex-direction: column;
            }
            
            .info-item2{
                flex-direction: unset;
            }
            
            .info-label {
                width: 100%;
                margin-bottom: 5px;
            }
            
            .info-label2{
                width:unset;
            }
            .popup-container{
                width:95% !important;
            }
        }
    </style>
</head>
<body>
   
<div class="background_color background_color2" style="width: 100%;">
     <div class="popup-container">
        <div class="popup-header">
            <div>
                <div class="profile-photo">
                    <img src="<?= base_url('beneficiary/profile/'.$beneficiary['profile']) ?>" class="profile-img" alt="Profile Photo">
                </div>
            </div>
            <div class="profile-info">
                <h1 class="profile-name"><?= esc($beneficiary['full_name']) ?></h1>
                <div class="profile-category"><?= esc($beneficiary['category']) ?> Beneficiary</div>
                <div class="status-badge"><i class="fas fa-circle"></i> <?= ($beneficiary['status'] == 1) ? 'Active' : 'Inactive' ?></div>
                <div class="info-item info-item2">
                    <div class="info-label info-label2">Gender:</div>
                    <div class="info-value"><?= esc($beneficiary['gender']) ?></div>
                </div>
                <div class="info-item info-item2">
                    <div class="info-label info-label2">Age:</div>
                    <div class="info-value"><?= esc($beneficiary['age']) ?></div>
                </div>
            </div>
        </div>
        
        <div class="popup-body">
            <div class="info-grid">
                <div class="info-card">
                    <h3 class="card-title"><i class="fas fa-user-circle"></i> Personal Information</h3>
                    <div class="info-item">
                        <div class="info-label">Date of Birth:</div>
                        <div class="info-value"><?= esc($beneficiary['dob']) ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Father's Name:</div>
                        <div class="info-value"><?= esc($beneficiary['father_name']) ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Mobile:</div>
                        <div class="info-value"><?= esc($beneficiary['mobile']) ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Email:</div>
                        <div class="info-value"><?= esc($beneficiary['email']) ?></div>
                    </div>
                </div>
                
                <div class="info-card">
                    <h3 class="card-title"><i class="fas fa-map-marker-alt"></i> Location Details</h3>
                    <div class="info-item">
                        <div class="info-label">State:</div>
                        <div class="info-value"><?= esc($beneficiary['state']) ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">District:</div>
                        <div class="info-value"><?= esc($beneficiary['district']) ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Address:</div>
                        <div class="info-value"><?= nl2br(esc($beneficiary['address'])) ?></div>
                    </div>
                </div>
                
                <div class="info-card">
                    <h3 class="card-title"><i class="fas fa-tags"></i> Category Details</h3>
                    <div class="info-item">
                        <div class="info-label">Category:</div>
                        <div class="info-value"><?= esc($beneficiary['category']) ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label">Caste Category:</div>
                        <div class="info-value"></span> <?= esc($beneficiary['category1']) ?></div>
                    </div>
                </div>
            </div>
            
            <div class="id-proof-section">
                <h3 class="section-title"><i class="fas fa-id-card"></i> Identification Documents</h3>
                <div class="id-proof-grid">
                    <div class="id-proof-card">
                        <p><span class="info-label">Identification Type 1:</span> <?= esc($beneficiary['identification_type']) ?></p>
        <?php if(!empty($beneficiary['idimage1'])): ?>
            <div class="document_img">
                <img src="<?= base_url('beneficiary/idproof/'.$beneficiary['idimage1']) ?>" class="id-img" alt="ID Proof 1">
            </div>
        <?php endif; ?>
                    </div>
                    <div class="id-proof-card">
                        <p><span class="info-label">Identification Type 2:</span> <?= esc($beneficiary['identification_type2']) ?></p>
        <?php if(!empty($beneficiary['idimage2'])): ?>
          <div class="document_img">
              <img src="<?= base_url('beneficiary/idproof2/'.$beneficiary['idimage2']) ?>" class="id-img" alt="ID Proof 2">
          </div>
        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="remark-section">
                <h3 class="section-title"><i class="fas fa-sticky-note"></i> Remarks</h3>
                <div class="remark-content"><?= nl2br(esc($beneficiary['remark'])) ?></div>
            </div>
        </div>
    </div>
    
    <button class="go_back" onclick="history.back()">Go Back</button>
    
</div>   

</body>
</html>