<?php
$session = session();
$admin_id = $session->admin_id;
require 'db_config.php';

$queryli = "SELECT * FROM admin_website_update";
$result = mysqli_query($connection, $queryli);
$dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en" class="bg-dark">
<head>
    <meta charset="utf-8" />
    <title><?= esc($heading) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="<?php echo base_url('public/css/font.css')?>" type="text/css" />
    <link rel="stylesheet" href="<?php echo base_url('public/css/popup.css')?>" type="text/css" />
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>"/>
    <link rel="stylesheet" href="<?php echo base_url('public/css/app.v1.css')?>" type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
     /* popup image code start */
     .thumbnail {
         width: 42px;
         height: 42px;
         object-fit: cover;
         margin: 0px;
         cursor: pointer;
         transition: transform 0.2s;
         border: none;
     }
     .thumbnail:hover {
         transform: scale(1.05);
         border-color: #888;
         }
         
     .gallery { 
         display:flex;
         flex-wrap:wrap;
         justify-content:center;
         max-width:1200px;
         margin:0 auto; 
         
     }
     .modal {
         display:none; 
         position:fixed; 
         top:0; left:0; 
         width:100%;
         height:100%; 
         z-index:1000;
         overflow:auto; 
         
     }
     .modal-content {
         position:relative; 
         display:inline-block;
         max-width:100%; 
         max-height:100%; 
         
     }
     .full-image {
         display:block; 
         width:400px;
         border-radius:5px;
         height:400px;
         object-fit:contain; 
         
     }
     
     .close-btn {
         position:absolute;
         top:5px;
         right:5px;
         color:white; 
         font-size:20px;
         font-weight:bold;
         cursor:pointer;
         background:rgba(0,0,0,0.5);
         width:40px; 
         height:40px; 
         border-radius:50%; 
         display:flex; 
         align-items:center; 
         justify-content:center;
         transition:all 0.3s; 
         
     }
     
     .close-btn:hover { 
         background:rgba(255,0,0,0.7);
         transform:scale(1.1); 
         
     }
     
     @media(max-width:500px){
         .full-image{ 
             width:320px !important;
             height:320px !important; 
             
         } 
         
     }
     
     /* popup image code end */

     table {
         width: 100%;
         border-collapse: collapse; 
         border: 2px solid #d4efda; 
         
     }
     
     th, td {
         text-align: left; 
         border-bottom: 2px solid #d4efda; 
         border-left: 2px solid #d4efda;
    }
         
     .member_ship_box{
         width: 90px;
         height: 90px;
         border-radius: 50%; 
         padding: 4px;
         background: white;
         margin: auto; transform:
         translate(0px, 65px);
         box-shadow: rgba(0,0,0,0.24) 0px 3px 8px; 
         
     }
     .winggo_logo_radius{
         width:100%;
         height:100%;
    }
     .icon-box {
         width: 42px;
         height: 42px; 
         background-color: #e9f7ef;
         display:flex; 
         align-items:center;
         justify-content:center; 
         color:#0a7e6b; 
         
     }
     
     .control-label{ 
         display:flex;
         align-items:center;
         gap:10px; margin:0 !important; 
         color:black; 
         font-weight:600; 
         
     }
     
     td p{ 
         padding-left:5px;
         margin:0; 
         
     }
     .profile-img { 
         width: 60px;
    height: 60px;
    box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
    cursor: pointer;
    margin: 5px;
         }
         
.details_heading {
    font-size: 15px;
    font-weight: 600;
    text-align: center;
    background: #0a7e6b;
    color: white;
    padding: 10px;
    border-radius: 4px;
}         
         
    </style>
</head>
<body class="bg-dark background_color background_color2">
    <section id="content" class="m-t-lg animated fadeInDown">
        <div class="container aside-xxl">
            <div class="member_ship_box">
                <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius" alt="logo">
            </div>

            <section class="panel panel-default m-t-lg bg-white">
               
                <header class="panel-heading text-center" style="padding-top:40px;">
                    <strong><?= esc($heading) ?></strong>
                </header>

                <div class="panel-body wrapper-lg">
                    
                    <h5 class="details_heading" style="margin-top: -19px;">Personal Information</h5>
                    
                    <table>

                        <tr>
                            <td>
                                <label class="control-label">
                                    <div class="icon-box"><i class="fa-regular fa-id-card"></i></div>Name:
                                </label>
                            </td>
                            <td><p><?= esc($application['full_name']) ?></p></td>
                        </tr>


                        <tr>
                            <td>
                                <label class="control-label">
                                    <div class="icon-box"><i class="fa-solid fa-envelope"></i></div>Email:
                                </label>
                            </td>
                            <td><p><?= esc($application['email']) ?></p></td>
                        </tr>

                        <tr>
                            <td>
                                <label class="control-label">
                                    <div class="icon-box"><i class="fa-solid fa-phone"></i></div>Mobile:
                                </label>
                            </td>
                            <td><p><?= esc($application['mobile_number']) ?></p></td>
                        </tr>

                        

                        <!-- Internship & other info rows using icon-box style -->
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-graduation-cap"></i></div>Qualification:</label></td>
                            <td><p><?= esc($application['qualification']) ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-book"></i></div>Course:</label></td>
                            <td><p><?= !empty($application['course_name']) ? esc($application['course_name']) : 'N/A' ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-building-columns"></i></div>College:</label></td>
                            <td><p><?= esc($application['college_name']) ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-map-marker-alt"></i></div>State:</label></td>
                            <td><p><?= esc($application['state']) ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-map-pin"></i></div>District:</label></td>
                            <td><p><?= esc($application['district']) ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-location-dot"></i></div>Address:</label></td>
                            <td><p><?= esc($application['address']) ?></p></td>
                        </tr>
                    </table>    
                     <h5 class="details_heading">Internship Information</h5>
                    <table>    
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-id-badge"></i></div>Internship ID:</label></td>
                            <td><p><?= esc($application['internship_id']) ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-briefcase"></i></div>Field:</label></td>
                            <td><p><?= !empty($application['internship_field']) ? esc($application['internship_field']) : 'N/A' ?></p></td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-clock"></i></div>Duration:</label></td>
                            <td><p><?= !empty($application['duration']) ? esc($application['duration']) : 'N/A' ?></p></td>
                        </tr>

                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa fa-file-pdf"></i></div>Resume:</label></td>
                            <td>
                                <?php if(!empty($application['resume'])): ?>
                                    <a href="<?= base_url('ResumeImage/'.$application['resume']) ?>" target="_blank">View / Download Resume</a>
                                <?php else: ?>
                                    <p class="text-muted">No resume uploaded</p>
                                <?php endif; ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-briefcase"></i></div>Created at:</label></td>
                            <td><p><?= date('d-m-y', strtotime( esc($application['created_at']))) ?></p></td>
                        </tr>
                        <tr>
                            <td><label class="control-label"><div class="icon-box"><i class="fa-solid fa-clock"></i></div>Last updated:</label></td>
                            <td><p><?= date('d-m-y', strtotime( esc($application['updated_at']))) ?></p></td>
                        </tr>
                        
                        </table>    
                     <h5 class="details_heading">Profile Photo</h5>
                    <table> 
                        
                        <tr>
                            <td> <label class="control-label"><div class="icon-box"><i class="fa-solid fa-image"></i></div> User Profile:</label> </td>
                            <td>
                                <p>
                                    <?php if(!empty($application['photo'])): ?>
                                        <img src="<?= base_url('InternImage/'.$application['photo'])?>" class="hover_image thumbnail profile-img" onclick="openFullImage(this.src)" alt="profile">
                                    <?php else: ?>
                                        <img src="<?= base_url('assets/default-user.png')?>" class="thumbnail profile-img" onclick="openFullImage(this.src)" alt="default">
                                    <?php endif; ?>
                                </p>
                            </td>
                        </tr>

                    </table>

                    <div class="mt-4 text-center" style="margin-top: 20px;">
                        <button class="btn btn-primary" style="width: 100%;" onclick="history.back()">Go Back</button>
                    </div>

                </div>
            </section>
        </div>
    </section>

    <!-- Scripts -->


    <script>
        // Image modal functions
        function openFullImage(src) {
            const modal = document.getElementById("imageModal");
            const fullImage = document.getElementById("fullImage");
            fullImage.src = src;
            modal.style.display = "flex";
            modal.style.justifyContent = "center";
            modal.style.alignItems = "center";
            document.body.style.overflow = "hidden";
        }

        function closeModal() {
            const modal = document.getElementById("imageModal");
            modal.style.display = "none";
            document.body.style.overflow = "auto";
        }

        window.addEventListener('click', function(event) {
            if (event.target === document.getElementById("imageModal")) {
                closeModal();
            }
        });

        document.addEventListener('keydown', function(event) {
            if (event.key === "Escape") closeModal();
        });
    </script>

    <!-- Image modal -->
    <div id="imageModal" class="modal">
      <div class="modal-content">
        <span class="close-btn" onclick="closeModal()">X</span>
        <img id="fullImage" class="full-image" alt="Full Image">
      </div>
    </div>
</body>
</html>
