<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Active Donation Projects</title>
     
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    
    <style>
    
    
    .container{
        width:100% !important;
    }
       
        .navbar-brand {
            font-weight: 700;
        }
        .card {
            border-radius: 10px;
            box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
            margin-bottom: 25px;
            border: none;
            transition: transform 0.3s;
            padding:25px;
        }
        .card:hover {
            transform: translateY(-5px);
        }
        .project-img {
            height:100%;
            width:100%;
        }
        .progress {
            height: 10px;
            border-radius: 5px;
            margin-top:5px;
            background:#c6c8cb !important;
        }
        .progress_bar {
            background-color: green;
            transition: width 2s ease-in-out;
        }
        .expense-badge {
            background-color: #e74a3b;
            font-size: 0.8rem;
        }
        .category-badge {
            background-color: #36b9cc;
            font-size: 0.8rem;
        }
        .expense-list {
            max-height: 200px;
            overflow-y: auto;
        }
        .expense-item {
            border-left: 3px solid #4e73df;
            padding-left: 10px;
            margin-bottom: 10px;
        }
        .receipt-thumb {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 5px;
            cursor: pointer;
        }
        .total-expense {
            font-weight: bold;
            color: #e74a3b;
        }
        .remaining-amount {
            font-weight: bold;
            color: #1cc88a;
        }
        
.header_text{
    display: flex;
    align-items: center;
    justify-content: center;
    background: #0a7e6b;
    padding: 10px;
    border-radius: 10px;
    color: white;
    margin-bottom: 30px;
}



/* popup image code statrt */

.thumbnail {
    width: 40px;
    height: 40px;
    /* object-fit: cover; */
    margin: 10px;
    cursor: pointer;
    border: 2px solid #ddd;
    transition: transform 0.2s;
    /* border: none; */

}
    
.thumbnail:hover {
    transform: scale(1.05);
    border-color: #888;
}
    
.gallery {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    max-width: 1200px;
    margin: 0 auto;
}
    
.modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    /*background-color: rgba(0, 0, 0, 0.9);*/
    z-index: 1000;
    overflow: auto;
}
    
.modal-content {
    position: relative;
    display: inline-block;
    max-width: 100%;
    max-height: 100%;
}
    
.full-image {
    display: block;
    width: 400px;
    border-radius: 5px;
    height: 400px;
    object-fit: contain;
    }
    
.close-btn {
    position: absolute;
    top: 5px;
    right: 5px;
    color: white;
    font-size: 20px;
    font-weight: bold;
    cursor: pointer;
    background: rgba(0, 0, 0, 0.5);
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}
    
.close-btn:hover {
    background: rgba(255, 0, 0, 0.7);
    transform: scale(1.1);
}
    
@media(max-width:500px){
    .full-image {
        width: 320px !important;
        height: 320px !important;
    } 
    
    .card_data{
        flex-flow:column;
}

.project_image{
    width:100% !important;
}

.data_box{
    width:100% !important;
}

.button_head{
    flex-flow:column;
    gap:unset !important;
    margin-bottom: 20px;
}

/*.projectImg {*/
/*    width: 100% !important;*/
/*    height: 200px !important;*/
/*}   */

.card_data{
    gap:10px !important;
}
    
}
    
/* popup image code end */

table{
    width:100%;
    margin-bottom: 10px;
}

th{
   padding: 10px;
   font-weight: 600;
   text-align: center;
}

td{
    text-align:center;
}

.card_data{
    display:flex; 
    gap:30px;
    align-items: center;
}

.project_image{
    width:25%;
}

.data_box{
    width:75%;
}

.button_head{
    display: flex;
    align-items: center;
    gap: 10px;
}

.projectImg{
    /*width: 100%;*/
    /*height: 270px;*/
    padding: 10px;
    margin: auto;
}
    </style>
</head>
<body>
    <?php $session = session();?>
    <!-- Navigation -->
    
        <div class="header_text">
           <h1 style="font-size: 20px; margin: 0; font-weight: 600;"><?= $heading ?>
        </div> 
    

    <!-- Page Heading -->
    <div class="container py-4">
       
      <?php if(! is_null($session->getFlashdata('msg')) ):?>
         
    <?php include(__DIR__ . '/../success/success.php'); ?>
 
<? endif;?>


 <?php if(session()->getFlashdata('error')): ?>
        
        <?php include(__DIR__ . '/../errors/error.php'); ?>

<? endif;?>

        <!-- Projects Grid -->
        <div class="row" style="margin-bottom: 110px;">
            <?php foreach ($project as $proj): 
                // Calculate total expenses for this project
                $totalExpense = 0;
                $projectExpenses = [];
                foreach ($expense as $exp) {
                    if ($exp['project_id'] == $proj['id']) {
                        $totalExpense += $exp['amount'];
                        $projectExpenses[] = $exp;
                    }
                }
                $progress = ($totalExpense / $proj['target_amount']) * 100;
                if ($progress > 100) $progress = 100;
                $remaining = $proj['target_amount'] - $totalExpense;
            ?>
            <div class="col-lg-12">
                <div class="card" >
                    <div class="card_data">
                    <div class="project_image">
                        <div class="projectImg">
                            <img src="<?php echo base_url('DonationProjectsImage/'.$proj['image'])?>" class="project-img" alt="<?= $proj['title'] ?>">
                        </div>
                    </div>
                    <div class="card-body data_box">
                        
                        <div style="display: flex; justify-content: space-between;">
                            <div>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="card-title mb-0" style="font-size: 15px; font-weight: 600;"><?= $proj['title'] ?></h5>
                            <span class="badge category-badge"><?= ucfirst($proj['category']) ?></span>
                        </div>
                        <p class="card-text text-muted"><?= $proj['description'] ?></p>
                        <p class="text-muted"><i class="fas fa-map-marker-alt me-2"></i><?= $proj['location'] ?></p>
                        </div>
                        
                         <!-- Action Buttons -->
                        <div class="d-flex justify-content-between">
                            
                            <a href="<?php echo base_url('Project-Details/'.$proj['id'])?>" class="btn btn-primary" style="border-radius: 4px; padding: 3px 7px;"><i class="fa fa-eye" aria-hidden="true"></i></a>
                            
                            
                            <a href="<?php echo base_url('Project-Edit/'.$proj['id'])?>" class="btn btn-primary" style="border-radius: 4px; padding: 3px 7px;"><i class="fa fa-pencil-square" aria-hidden="true"></i></a>
                            
                            <a href="<?php echo base_url('Project-Delete/'.$proj['id'])?>"class="btn btn-danger" style="border-radius: 4px; padding: 3px 7px;" onclick="return confirm('Are you sure you want to delete this Project?')"><i class="fa fa-trash" aria-hidden="true"></i></a>
                        </div>
                        </div>
                        
                        <!-- Progress Bar -->
                        <div class="mb-3">
                            <div style="display: flex; justify-content: space-between;">
                                <div class="d-flex justify-content-between mb-1">
                                <small>Expense: ₹<?= number_format($totalExpense, 2) ?></small>
                                <small>Goal: ₹<?= number_format($proj['target_amount'], 2) ?></small>
                            </div>
                             <div class="text-end mt-1">
                                <small class="<?= $remaining >= 0 ? 'remaining-amount' : 'total-expense' ?>">
                                    <?= $remaining >= 0 ? 'Remaining: ₹'.number_format($remaining, 2) : 'Over Budget: ₹'.number_format(abs($remaining), 2) ?>
                                </small>
                            </div>
                            </div>
                          <div style="width: 100%; height: 11px; background-color: #e0e0e0; border-radius: 8px; overflow: hidden;">
  <div style="width: <?= $progress ?>%; height: 100%; background-color: #4caf50; text-align: center; color: white; font-size: 14px; line-height: 10px;">
    
  </div>
</div>

                           
                        </div>
                        
                        
                       
                    </div>
                    </div>
                    <div>
                        <!-- Expenses Section -->
                        <div class="accordion mb-3" id="expenseAccordion<?= $proj['id'] ?>">
                            <div class="accordion-item">
                                <div class="button_head">
                                    <span class="accordion-header" id="heading<?= $proj['id'] ?>">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                        data-bs-target="#collapse<?= $proj['id'] ?>" aria-expanded="false" 
                                        aria-controls="collapse<?= $proj['id'] ?>" style="    padding: 5px;
    font-size: 15px;
    font-weight: 600;
    background: #00a783;
    margin: 9px 0px;
    color: white;
    border: none;
    width: 190px;
    border-radius: 5px;">
                                        <i class="fas fa-receipt me-2"></i> Project Expenses 
                                        <span class="badge expense-badge ms-2"><?= count($projectExpenses) ?></span>
                                    </button>
                                </span>
                                
                                
                                 <span class="accordion-header" id="heading<?= $proj['id'] ?>">
                                     <a href="<?= base_url('report_expense_Download/'.$proj['id'])?>">
                                    <button class="accordion-button collapsed" type="button"  style="    padding: 5px;
    font-size: 15px;
    font-weight: 600;
    background: #00a783;
    margin: 9px 0px;
    color: white;
    border: none;
    width: 190px;
    border-radius: 5px;">
                                        <i class="fas fa-receipt me-2"></i> Project Report
                                        <span class="badge expense-badge ms-2"><?= count($projectExpenses) ?></span>
                                    </button>
                                </span>
                                
                                
                                
                                
                                
                                
                                
                                  <div class="d-flex justify-content-between">
                           
                            <?php if($totalExpense >=$proj['target_amount']){ ?>
                           <a href="#"
                                    class="btn btn-primary" style="border-radius: 5px; width: 190px; font-weight: 600;" ><i class="fas fa-receipt me-1"></i> Complete</a>
                                    <?php } else { ?>
                                       <a href="<?php echo base_url('Project-Add-Expense/'.$proj['id'])?>"
                                    class="btn btn-primary" style="border-radius: 5px; width: 190px; font-weight: 600;" ><i class="fas fa-receipt me-1"></i> Add Expense</a>
                                    <?php } ?>
                          
                        </div>
                                </div>
                                <div id="collapse<?= $proj['id'] ?>" class="accordion-collapse collapse" 
                                    aria-labelledby="heading<?= $proj['id'] ?>" data-bs-parent="#expenseAccordion<?= $proj['id'] ?>">
                                    <div class="accordion-body p-0">
                                        <?php if (!empty($projectExpenses)): ?>
                                        <div class="expense-list p-3">
                                            
                                           
                                           
                                            <table border="1" cellpadding="10" cellspacing="0">
  <thead>
    <tr>
      <th>S.No</th>
      <th>Name</th>
      <th>Product Name</th>
      <th>Amount</th>
      <th>Expense Date</th>
      <th>Paid Amount</th>
      <th>Payment Mode</th>
      <th>Receipt Image</th>
      <th>Action</th>
    </tr>
  </thead>
  <?php $i = 1;?>
 
 <?php foreach ($projectExpenses as $exp): ?>
                                      
  <tbody>

 
    <tr>
      <td><?= $i++?></td>
      <td><?= $exp['name'] ?></td>
      <td><?= $exp['product_name'] ?></td>
      <td>₹<?= number_format($exp['amount'], 2) ?></td>
      <td><?= date('d M Y', strtotime($exp['expense_date'])) ?></td>
      <td><?= $exp['paid_to'] ?></td>
      <td><?= $exp['payment_mode'] ?></td>
      <td> <?php if ($exp['receipt_image']): ?>
            <a href="#" style="display: flex; justify-content: center;">
                <img src="<?php echo base_url('ProjectExpenseImage/'.$exp['receipt_image'])?>" class="receipt-thumb thumbnail" onclick="openFullImage(this.src)" alt="Receipt">
            </a>
            <?php endif; ?></td>
      <td colspan="2">
          
          <div style="display:flex; gap:5px; padding:5px;">
              <a href="<?php echo base_url('Project-Expense-Details/'.$exp['id'])?>" class="btn btn-primary" style="border-radius: 4px; padding: 3px 7px;">
                <i class="fa fa-eye" aria-hidden="true"></i>
            </a>
          
            <a href="<?php echo base_url('Project-Expense-Edit/'.$exp['id'])?>" class="btn btn-primary" style="border-radius: 4px; padding: 3px 7px;">
                <i class="fa fa-pencil-square" aria-hidden="true"></i>
            </a>
            <a href="<?php echo base_url('Project-Expense-Delete/'.$exp['id'])?>" class="btn btn-danger" style="border-radius: 4px; padding: 3px 7px;" onclick="return confirm('Are you sure you want to delete this Project Expense?')">
                <i class="fa fa-trash" aria-hidden="true"></i>
            </a>
          </div>
          
        </td>            
    </tr>
    
  </tbody>
   <?php endforeach; ?>
</table>

                                        
                                        
                                           
                                        </div>
                                        <?php else: ?>
                                        <div class="text-center py-3 text-muted">
                                            <i class="fas fa-info-circle me-2"></i> No expenses recorded yet
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                         <!-- Action Buttons -->
                      
                        <div class="card-footer text-muted">
                        <small>Created on <?= date('d M Y, h:i A', strtotime($proj['created_at'])) ?></small>
                    </div>
                    </div>
                    
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Animate progress bars on page load
        document.addEventListener('DOMContentLoaded', function() {
            const progressBars = document.querySelectorAll('.progress_bar');
            progressBars.forEach(bar => {
                const targetWidth = bar.style.width;
                bar.style.width = '0';
                setTimeout(() => {
                    bar.style.width = targetWidth;
                }, 100);
            });
        });
    </script>
    

<!-- popup Image code statrt -->
<script>
  function openFullImage(src) {
    const modal = document.getElementById("imageModal");
    const fullImage = document.getElementById("fullImage");
    
    fullImage.src = src;
    modal.style.display = "flex";
    modal.style.justifyContent = "center";
    modal.style.alignItems = "center";
    document.body.style.overflow = "hidden";
  }
  
  function closeModal() {
    document.getElementById("imageModal").style.display = "none";
    document.body.style.overflow = "auto";
  }
  
  // Close when clicking outside image
  window.addEventListener('click', function(event) {
    if (event.target === document.getElementById("imageModal")) {
      closeModal();
    }
  });
  
  // Close with ESC key
  document.addEventListener('keydown', function(event) {
    if (event.key === "Escape") {
      closeModal();
    }
  });
</script>

<div id="imageModal" class="modal">
  <div class="modal-content">
    <span class="close-btn" onclick="closeModal()">X</span>
    <img id="fullImage" class="full-image">
  </div>
</div>

<!-- popup Image code end -->    
</body>
</html>