<?php
 require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Internship Completion Certificate</title>
       <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
    integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
    crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="<?php echo base_url('public/qrcode.min.js')?>"></script>
     <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
  

    <style>
        /* keep your existing styles here (no change) */

table{
    margin-top: 15px !important;
    border: 1px solid #d4efda !important;
}
        
th, td {
    text-align: left;
    border-bottom: 1px solid #d4efda !important;
    border-left: 1px solid #d4efda !important;
}

.member_ship_box {
    width: 250px;
    height: 250px;
    border-radius: 50%;
    padding: 4px;
    margin: auto;
    margin-top: -272px;
    opacity: 0.05;
}

.winggo_logo_radius{
    width:100%;
    height:100%;
}

    
        @import url('https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Montserrat:wght@300;400;500&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        .certificate-container {
            width: 100%;
            max-width: 800px;
            background: #fff;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            border-radius: 15px;
            overflow: hidden;
            position: relative;
            margin: 17px auto;
        }
        
        .certificate-header {
            background: linear-gradient(135deg, #1a2a6c 0%, #2b5876 100%);
            color: white;
            padding: 20px;
            text-align: center;
            position: relative;
        }
        
.certificate-header h1 {
    font-family: 'Playfair Display', serif;
    font-size: 30px;
    font-weight: 600;
    letter-spacing: 2px;
    margin: 0;
}
        
        .certificate-header p {
            font-size: 1.2rem;
            opacity: 0.9;
            margin:0;
        }
        
        .certificate-body {
            padding: 20px;
            position: relative;
        }
        
        .certificate-content {
            text-align: center;
            margin-bottom: 20px;
        }
        
.certificate-text {
    font-size: 15px;
    text-align: justify;
    line-height: 20px;
    margin: 0;
}
        
.recipient-name {
    font-family: 'Playfair Display', serif;
    font-size: 19px;
    color: #1a2a6c;
    margin: 25px 0;
    text-align: center;
    font-weight: 700;
}
        
        .internship-details {
            margin: 30px 0;
            padding: 20px;
            background: #f9f9f9;
            border-radius: 10px;
            border-left: 5px solid #1a2a6c;
        }
        
        .details-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin-top: 20px;
        }
        
        .detail-item {
            display: flex;
            flex-direction: column;
        }
        
        .detail-label {
            font-weight: 600;
            color: #1a2a6c;
            margin-bottom: 5px;
        }
        
        .signature-area {
            display: flex;
            justify-content: space-between;
            padding-top: 30px;
            border-top: 2px solid #e0e0e0;
        }
        
        .signature {
            text-align: center;
            width: 45%;
        }
        
        .signature-line {
            width: 200px;
            height: 1px;
            background: #333;
            margin: 10px auto;
        }
        
        .certificate-footer {
            padding: 20px;
            text-align: center;
            background: #f5f7fa;
            font-size: 0.9rem;
            color: #666;
        }
        
        .certificate-id {
            margin-top: 10px;
            font-style: italic;
        }
        
.logo {
    width: 80px;
    height: 80px;
    padding: 4px;
    background: #fff;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    margin: auto;
}

.logo img{
    width:100%;
    height:100%;
    border-radius:50%;
}
        
        .download-btn {
            display: block;
            width: 200px;
            margin: 30px auto;
            padding: 12px 20px;
            background: linear-gradient(135deg, #1a2a6c 0%, #2b5876 100%);
            color: white;
            text-align: center;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(26, 42, 108, 0.2);
        }
        
        .download-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(26, 42, 108, 0.3);
        }
        
       .background_color {
    background-image: linear-gradient(45deg, rgba(255, 255, 255, 0.03) 25%, transparent 25%), linear-gradient(-45deg, rgba(255, 255, 255, 0.03) 25%, transparent 25%), linear-gradient(45deg, transparent 75%, rgba(255, 255, 255, 0.03) 75%), linear-gradient(-45deg, transparent 75%, rgba(255, 255, 255, 0.03) 75%);
    /* display: flex
; */
    justify-content: center;
    align-items: center;
    background-color: #00665f !important;
    overflow: auto;
    height: 100vh;
    
.water_mark{
    display: flex;
    justify-content: center;
    align-items: center;
}    
    
    
</style>
</head>
<body>
    
<div class="background_color">
    <div class="certificate-container" id="content-to-pdf">
        <div>
            <div class="certificate-header">
            <h1>INTERNSHIP COMPLETION CERTIFICATE</h1>
            <p>This certifies that the following individual has successfully completed their internship program</p>
        </div>
        
        <div class="certificate-body">
            <div class="logo">
                <img src="<?php echo base_url( 'InternImage/'.$application['photo']);?>" class="logo_img_2">
            </div>
            
            <div class="certificate-content">
                <p class="certificate-text">
                    This is to certify that <span class="recipient-name"><?php echo $application['full_name']; ?></span>
                    has successfully completed the internship program in <strong><?php echo $internship['title']??'N/A'; ?></strong>
                    from <strong><?php echo date('F j, Y', strtotime($internship['start']??'N/A')); ?></strong> to 
                    <strong><?php echo date('F j, Y', strtotime($internship['end']??'N/A')); ?></strong>. During this period, 
                    the intern demonstrated dedication, professionalism, and acquired valuable skills in their field of work.
                </p>
                
                <div class="internship-details">
                    <h3>Internship Details</h3>
                    <div class="details-grid">
                        <div class="detail-item">
                            <span class="detail-label">Internship Field:</span>
                            <span><?php echo $internship['category']??'N/A'; ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Internship Type:</span>
                            <span><?php echo $internship['type']??'N/A'; ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Qualification:</span>
                            <span><?php echo $application['qualification']; ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">College/Institution:</span>
                            <span><?php echo $application['college_name']; ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Duration:</span>
                            <span><?php echo $internship['duration']??'N/A'; ?></span>
                        </div>
                        <div class="detail-item">
                            <span class="detail-label">Stipend:</span>
                            <?php if($internship){ ?>
                            <span><?php echo $internship['stipend'] === 'Yes' ? '₹' . $internship['stipendAmount'] : 'No Stipend'; ?></span>
                            <?php } ?>
                        </div>
                    </div>
                </div>

<div className="water_mark">
    <div>
        <div class="member_ship_box">
	     	<img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
	    </div>
    </div>
</div>
                
                <p class="certificate-text">
                    The intern has shown exceptional commitment to learning and applying new skills throughout the internship period. 
                    We wish them continued success in their future endeavors.
                </p>
            </div>
            
            <div class="signature-area">
                <div class="signature">
                    <div class="signature-line"></div>
                    <p>Intern's Signature</p>
                </div>
                <div class="signature">
                    <img src="<?php echo base_URL('certificateProviderSignature/'.$dataweb['certificate_provider_signature']);?>" style="width: 120px;">
                    <div class="signature-line"></div>
                    <p style="margin:0;">Authorized Signature</p>
                    <p style="margin:0;">Internship Coordinator</p>
                </div>
            </div>
        </div>
        
        <div class="certificate-footer">
            <p style="margin:0;">Issued on: <?php echo date('F j, Y'); ?></p>
            <p style="margin:0;" class="certificate-id">Certificate ID: INTERN-<?php echo strtoupper(substr($application['full_name'], 0, 3)); ?>-<?php echo $application['id']; ?></p>
        </div>
        
       <div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Expense Receipt</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalReceiptImg" src="" alt="Receipt" class="img-fluid rounded">
            </div>

        </div>
    </div>
</div>
        </div>

    </div>

<div class="text-center mt-4 mb-4">
    <button onclick="history.back()" class="btn download_btn_pdf" style=" background: #f7f7f7 !important; color: #00665f !important; width: 140px;">Go Back</button>
    <button onclick="generatePDF()" class="btn download_btn_pdf" style=" background: #f7f7f7 !important; color: #00665f !important; width: 140px;">Download PDF</button>
</div>
</div>    
   
<script>
function generatePDF() {
    window.scrollTo(0, 0);
    const element = document.getElementById('content-to-pdf');
    const name = "<?php echo $application['full_name']; ?>";

    setTimeout(() => {
        const opt = {
            margin:       0,
            filename:     name + '.pdf',
            image:        { type: 'jpeg', quality: 1 }, // best image quality
            html2canvas:  {
                scale: 12,           // increase scale for better quality
                useCORS: true,      // use this if you're loading images from other domains
                allowTaint: false,
                logging: false,
                backgroundColor: '#ffffff' // force white background if transparent
            },
            jsPDF:        {
                unit: 'mm',
                format: 'a4',
                orientation: 'portrait'
            }
        };

        html2pdf().set(opt).from(element).save();
    }, 500);
}
</script>

</body>
</html>