
<?php
               
               $session = session();
               $admin_id = $session->admin_id;
                        require 'db_config.php';
                        
                        
                         $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);
                         
                        
                        ?>
                        
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $heading ?> - Campaigns</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        :root {
            --primary-color: #0a7e6b;
            --hover-color: #c6c8cb;
            --secondary-color: #3f37c9;
            --accent-color: #4cc9f0;
            --light-bg: #f8f9fa;
            --dark-text: #212529;
        }
        
 header {
      background: #f0f7f4;
      box-shadow: 0 2px 15px rgba(0,0,0,0.1);
      padding: 15px 20%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      position: sticky;
      top: 0;
      z-index: 1000;
    }

    header .logo-area {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    header .logo-area img {
      height: 50px;
      width: 50px;
      object-fit: contain;
    }

    header h2 {
      margin: 0;
      font-size: 22px;
      color: black;
      font-weight: 700;
    }

header nav a {
    margin-left:10px;
    text-decoration: none;
    color: white;
    font-weight: 500;
    transition: color 0.3s;
    position: relative;
    background: #e67d07;
    background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    padding: 8px 20px;
    border-radius: 9px;
    text-decoration:none;
}

    header nav a:hover {
      color: white;
    }

 
        
        .campaign-card {
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            border: none;
        }
        .campaign-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        .campaign-img {
            height: 200px;
            width: 100%;
            /*object-fit: cover;*/
        }
        .progress {
            height: 10px;
        }
        .category-badge {
            position: absolute;
            top: 10px;
            background: white !important;
            right: 10px;
            color: rgb(23 55 74)!important;
        }
        .search-container {
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        .no-campaigns {
            min-height: 300px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .donation-badge {
            position: absolute;
            top: 10px;
            left: 10px;
            background-color: rgba(0,0,0,0.7);
        }
        .donation-progress {
            height: 6px;
        }
        .donor-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }
        .pagination-container {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            margin-bottom: 50px;
        }
        .pagination {
            display: flex;
            list-style: none;
            padding: 0;
        }
        .page-item {
            margin: 0 5px;
        }
        .page-link {
            color: #0a7e6b;
            background-color: white;
            border: 1px solid #dee2e6;
            padding: 8px 16px;
            border-radius: 4px;
            transition: all 0.3s;
        }
        .page-link:hover {
            background-color: #f1f1f1;
            border-color: #dee2e6;
        }
        .page-item.active .page-link {
            background-color: #0a7e6b;
            border-color: #0a7e6b;
            color: white;
        }
        .page-item.disabled .page-link {
            color: #6c757d;
            pointer-events: none;
            background-color: white;
            border-color: #dee2e6;
        }
        .btn-details {
            border: 2px solid #08314f;
            color: #08314f;
            font-weight: 600;
            padding: 8px 20px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }  
        .donate_btn:hover {
            background:#08314f !important;
            color:white;
        }
        .btn-details:hover {
            background: #e67d07 !important;
            color:white !important;
        }
        .donate_btn {
            color: white;
            background: #e67d07;
            font-weight: 600;
            padding: 8px 25px;
            border-radius: 8px;
            border: none;
            transition: all 0.3s ease;
        }    
        .card-title {
            font-weight: 700;
            margin-bottom: 0.75rem;
            font-size: 1.25rem;
        }
        .text_muted {
            color: #6c757d;
            margin-bottom: 1rem;
            font-size: 0.9rem;
            line-height: 1.5;
        }
        .section-title {
            font-weight: 600;
            color: var(--dark-color);
            margin-bottom: 2rem;
            position: relative;
            display: inline-block;
        }
        .section-title:after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 0;
            width: 70px;
            height: 3px;
            background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
            border-radius: 3px;
        }
        
/* Gradient background animation */
  .animated-gradient {
    background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    padding: 20px 0;
  }

  /* Heading animation */
  .animated-fade-in {
    color:#fff;
    font-weight:700;
    text-align:center;
    margin-bottom:30px;
    text-shadow: 1px 1px 4px rgba(0,0,0,0.3);
    opacity:0;
    transform: translateY(-20px);
    animation: fadeIn 1.5s ease forwards;
  }
  @keyframes fadeIn {
    to {opacity:1; transform: translateY(0);}
  }

  /* Filter box animation */
  .animated-slide-up {
    background: rgba(255,255,255,0.95);
    padding:30px;
    border-radius:16px;
    box-shadow:0 10px 30px rgba(0,0,0,0.1);
    backdrop-filter: blur(10px);
    opacity:0;
    transform: translateY(40px);
    animation: slideUp 1.5s ease forwards;
    animation-delay: 0.6s;
  }
  @keyframes slideUp {
    to {opacity:1; transform: translateY(0);}
  }

  /* Campaign count badge */
  .campaign-count {
    background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
    color:white;
    padding:8px 16px;
    border-radius:20px;
    font-weight:600;
    display:inline-block;
  }

  .filter-label {
    font-weight:600;
    margin-bottom:8px;
    display:block;
  } 
  
  /* Footer */
    footer {
      /*background: #1a3c32;*/
    color: white;
    padding-bottom: 15px;
    }
    
.logo_box {
    width: 100px;
    height: 100px;
    display: flex;
    margin: auto;
}

.logo_box img{
    width:100%;
    height:100%;
}

.contact_info_box{
    display:flex;
    justify-content:center;
}

.contact_info{
    text-align: center;
    position: relative;
    margin: 0;
    padding-top: 17px;
    padding-bottom: 11px;
}

.contact_info::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 100%;
    height: 2px;
    background: white;
}
    
.footer-content {
    display: flex;
    justify-content: center;
    gap: 30px;
    padding-top: 20px;
}

    .footer-column h3 {
      margin-bottom: 20px;
      font-size: 1.3rem;
      position: relative;
      padding-bottom: 10px;
    }

    .footer-column h3::after {
      content: '';
      position: absolute;
      left: 0;
      bottom: 0;
      width: 40px;
      height: 2px;
      background: #1a936f;
    }

    .footer-column p, .footer-column a {
      color: white;
      margin-bottom: 10px;
      display: block;
      text-decoration: none;
      transition: color 0.3s;
    }


    .copyright {
      text-align: center;
      border-top: 1px solid rgba(255,255,255,0.1);
      color: #aaa;
      font-size: 0.9rem;
    }    
  
@media(max-width:500px){
    header {
         padding: 23px 1% !important;
         gap: 20px !important;
         flex-flow: column !important; 
    }
    
     .footer-content {
        flex-flow: column;
        gap: 10px !important;
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .footer-column p {
        margin: 0 !important;
        text-align: center;
    }
    
}  

.direct_top{
    position: fixed;
    bottom: 47px;
    right: 25px;
    background:  #db7a0b;
    width: 35px;
    color: white;
    height: 35px;
    display: flex;
    justify-content: center;
    align-items: center;
    border-radius: 50%;
    text-decoration: none;
    z-index: 100000;
}

#searchButton{
    background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);
}

input type="range"{
    background:red !important;
}
   .red-range {
    -webkit-appearance: none;
    width: 100%;
    height: 6px;
    background: #ffcccc; /* light red track */
    border-radius: 5px;
    outline: none;
}

/* Range Thumb */
.red-range::-webkit-slider-thumb {
    -webkit-appearance: none;
    appearance: none;
    width: 18px;
    height: 18px;
    background: #08314f;
    border-radius: 50%;
    cursor: pointer;
}

/* For Firefox */
.red-range::-moz-range-thumb {
    width: 18px;
    height: 18px;
    background: red;
    border-radius: 50%;
    cursor: pointer;
}
     
    </style>
</head>
<body style="background-color:#f5f7ff;">
    
<a href="#" class="direct_top"><i class="fa-solid fa-arrow-up"></i></a>

<!-- Header Section -->
  <header>
    <!-- Left Side: Logo + NGO Name -->
    <div class="logo-area">
       <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
      <div>
          <h2><?php echo $dataweb['web_name']?></h2>
          <p style="margin:0; color:black;"><?php echo $dataweb['web_tag_line']?></p>
      </div>
    </div>

    <!-- Right Side: Navigation -->
    <nav>
      <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
            <i class="fa-solid fa-house-user"></i> Home
        </a>
        
      <a href="tel:<?php echo $dataweb['site_mobile_1'] ?>" style="color: white;
    padding-left: 20px;
    text-decoration: none;">
    <i class="fa-solid fa-phone"></i> 
    <?php echo $dataweb['site_mobile_1'] ?>
</a>

    </nav>
  </header>
    
    <!-- ===== Top Header Section with Animation ===== -->
<div class="main_header animated-gradient">
  <div class="container">
    
    <!-- Heading -->
    <h1 class="animated-fade-in">
      Support Meaningful Causes
    </h1>

    <!-- Search & Filters Box -->
    <div class="search-container animated-slide-up">
      <div class="row g-3">
        <!-- Search -->
        <div class="col-md-6">
          <label for="searchInput" class="filter-label">Search Campaigns</label>
          <div class="input-group">
            <input type="text" class="form-control" id="searchInput" placeholder="Search campaigns...">
            <button class="btn btn-primary" id="searchButton">
              <i class="fas fa-search"></i> Search
            </button>
          </div>
        </div>

        <!-- Category -->
        <div class="col-md-3">
          <label for="categoryFilter" class="filter-label">Category</label>
          <select class="form-select" id="categoryFilter">
            <option value="">All Categories</option>
            <option value="Education Support">Education Support</option>
            <option value="Healthcare & Medical Aid">Healthcare & Medical Aid</option>
            <option value="Women Empowerment">Women Empowerment</option>
            <option value="Child Welfare">Child Welfare</option>
            <option value="Environment & Sustainability">Environment & Sustainability</option>
            <option value="Rural Development">Rural Development</option>
            <option value="Animal Welfare">Animal Welfare</option>
            <option value="Disaster Relief">Disaster Relief</option>
            <option value="Senior Citizen Care">Senior Citizen Care</option>
            <option value="Livelihood Support">Livelihood Support</option>
            <option value="Food & Nutrition">Food & Nutrition</option>
            <option value="Disabled Persons Support">Disabled Persons Support</option>
            <option value="Community Development">Community Development</option>
            <option value="Menstrual Hygiene Awareness">Menstrual Hygiene Awareness</option>
          </select>
        </div>

        <!-- Status -->
        <div class="col-md-3">
          <label for="statusFilter" class="filter-label">Status</label>
          <select class="form-select" id="statusFilter">
            <option value="">All Statuses</option>
            <option value="active">Active</option>
            <option value="upcoming">Upcoming</option>
            <option value="completed">Completed</option>
          </select>
        </div>
      </div>

      <!-- Amount Range + Count -->
      <div class="row g-3 mt-4 align-items-center">
        
        <!-- Amount Range -->
        <div class="col-md-6">
          <label for="amountRange" class="filter-label">Goal Amount: 
            <span id="amountValue">Any</span>
          </label>
         <input type="range" class="red-range form-range" min="0" max="10000000" step="1000" id="amountRange" value="0">

          <div class="d-flex justify-content-between text-muted small">
            <span>₹0</span>
            <span>₹1,00,00,000</span>
          </div>
        </div>

        <!-- Campaign Count -->
        <div class="col-md-6 text-md-end text-start mt-3 mt-md-0">
          <div class="campaign-count">
            Showing <span id="campaignCount"><?= count($campaign) ?></span> campaigns
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<div class="container py-5">
        <h1 class="section-title">Featured Campaigns</h1>
        
        <div class="row" id="campaignsContainer">
            <?php if (!empty($campaign)): ?>
                <?php foreach ($campaign as $item): 
                    $gallery_images = json_decode($item['gallery_images'] ?? '[]', true);
                    
                    // Calculate total donations for this campaign
                    $total_donations = 0;
                    
                    $campaign_donations = array_filter($donation, function($donation_item) use ($item) {
                        return $donation_item['campaign_id'] == $item['id'];
                    });
                    
                    foreach ($campaign_donations as $donation_item) {
                        $total_donations += $donation_item['amount'];
                    }
                    
                    $progress = ($item['goal_amount'] > 0) ? min(100, ($total_donations / $item['goal_amount'] * 100)) : 0;
                    $days_left = max(0, floor((strtotime($item['end_date']) - time()) / (60 * 60 * 24)));
                    
                    // Get recent donors (last 3)
                    $recent_donors = array_slice($campaign_donations, 0, 3);
                ?>
                
                    <div class="col-lg-4 col-md-6 mb-4 campaign-item" 
                         data-title="<?= strtolower($item['title']) ?>"
                         data-category="<?= $item['category'] ?>"
                         data-status="<?= $item['status'] ?>"
                         data-amount="<?= $item['goal_amount'] ?>">
                        <div class="card campaign-card h-100">
                            <div class="position-relative">
                                <img src="<?= base_url('CampaignsImage/' . $item['featured_image']) ?>" class="card-img-top campaign-img" alt="<?= $item['title'] ?>">
                                <span class="badge bg-primary category-badge"><?= $item['category'] ?></span>
                                <div style="display: flex; justify-content: space-between; padding: 12px; margin-bottom: -20px;">
                                    <p style="margin:0; font-size: 12px; font-weight: 600;">Start Date: <?= date('d M Y', strtotime($item['start_date'])) ?></p>
                                    <p style="margin:0; font-size: 12px; font-weight: 600;">End Date: <?= date('d M Y', strtotime($item['end_date'])) ?></p>
                                </div>
                                <?php
                                $id = $item['id'];
                                 require 'db_config.php';
          $queryli = "SELECT * FROM `campaign_donations` WHERE `campaign_id` = $id";
          $result = mysqli_query($connection, $queryli);
          $dataComp = mysqli_fetch_array($result, MYSQLI_ASSOC);
         
         
          ?>
                                <?php if (!empty($campaign_donations)): ?>
                                    <span class="badge donation-badge text-white">
                                        <i class="fa-solid fa-heart"></i> <?= count($campaign_donations) ?> donations
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title"><?= $item['title'] ?></h5>
                               <p class="card-text text-muted text_muted description" id="desc-<?= $item['id'] ?>">
    <?= mb_substr($item['description'], 0, 100, 'UTF-8') ?>
    
    <?php if (mb_strlen($item['description'], 'UTF-8') > 100): ?>
        <span class="dots">...</span>
        <span class="more-text" style="display:none;">
            <?= mb_substr($item['description'], 100, null, 'UTF-8') ?>
        </span>
        <button type="button" class="btn btn-link p-0 show-more-btn" data-id="<?= $item['id'] ?>" style="color:#08314f !important;">
            Show More
        </button>
    <?php endif; ?>
</p>


                                
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between mb-1">
                                       <div>
                                           
                                    <?php 
                                             $id = $item['id'];
require 'db_config.php';

$queryli = "SELECT SUM(amount) AS totalAmount FROM `campaign_donations` WHERE `campaign_id` = $id";
$result = mysqli_query($connection, $queryli);
$dataComp = mysqli_fetch_assoc($result);

?>        
                                            <small style="font-weight:600;">Raised: ₹<?= number_format($dataComp['totalAmount'], 2) ?></small><br>
                                            <small style="font-weight:600;">Goal: ₹<?= number_format($item['goal_amount'], 2) ?></small>
                                       </div>
                                       <div>
                                           <small><?= ceil($days_left) ?> days left</small><br>
                                           <small class="text-muted">
                                               <?php 
                                             $id = $item['id'];
require 'db_config.php';

$queryli = "SELECT COUNT(*) as total FROM `campaign_donations` WHERE `campaign_id` = $id";
$result = mysqli_query($connection, $queryli);
$dataComp = mysqli_fetch_assoc($result);

?>
<?php
$id = $item['id'];   // campaign_id
require 'db_config.php';

$queryli = "SELECT * FROM `campaign_donations` WHERE `campaign_id` = $id ORDER BY id DESC LIMIT 6";
$result = mysqli_query($connection, $queryli);

// Saara data ek array me aayega
$dataCompDeatils = mysqli_fetch_all($result, MYSQLI_ASSOC);
?>



                                               
                                               
                                               
                                               
                                              <?= $dataComp['total'] ?> Supporters</small>
                                       </div>
                                    </div>
                                    
                                    <?php
$id = $item['id'];   // campaign_id
require 'db_config.php';

$queryli = "SELECT SUM(amount) AS totalAmount FROM `campaign_donations` WHERE `campaign_id` = $id";
$result = mysqli_query($connection, $queryli);
$row = mysqli_fetch_assoc($result);

$totalAmount = $row['totalAmount'] ?? 0;

 $progress = ($item['goal_amount'] > 0) ? min(100, ($totalAmount / $item['goal_amount'] * 100)) : 0;
                    $days_left = max(0, floor((strtotime($item['end_date']) - time()) / (60 * 60 * 24)));
?>

<p><strong>Total Amount:</strong> <?= $totalAmount ?></p>

                                    
                                    <div class="progress">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: <?= $progress ?>%" 
                                             aria-valuenow="<?= $progress ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                
                                <?php if (!empty($dataCompDeatils)): ?>
                                    <div class="mb-3">
                                        <small class="text-muted">Recent donors:</small>
                                        <div class="d-flex align-items-center">
                                            <?php foreach ($dataCompDeatils as $donor): ?>
                                                <?php
                                                $name = trim($donor['name']);
                                                $words = explode(' ', $name);
                                                $firstInitial = isset($words[0][0]) ? strtoupper($words[0][0]) : '';
                                                $lastInitial = isset($words[count($words) - 1][0]) ? strtoupper($words[count($words) - 1][0]) : '';
                                                $initials = $firstInitial . $lastInitial;
                                                ?>

                                                <div class="position-relative me-2" data-bs-toggle="tooltip" title="<?= esc($donor['name']) ?> donated ₹<?= esc($donor['amount']) ?>">
                                                    <p style="font-size: 17px; height: 41px; width: 41px; color: white !important; border-radius: 23px; display: flex; justify-content: center; align-items: center; background: linear-gradient(135deg, #4361ee, #4cc9f0);">
                                                        <?= $initials ?>
                                                    </p>
                                                </div>
                                            <?php endforeach; ?>
                                            <?php if (count($campaign_donations) > 3): ?>
                                                <small class="text-muted ms-2">+<?= count($campaign_donations) - 3 ?> more</small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                               
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="badge bg-<?= $item['status'] === 'active' ? 'success' : ($item['status'] === 'upcoming' ? 'warning' : 'secondary') ?>" style="background:#08314f !important;">
                                        <?= ucfirst($item['status'] ?? 'unknown') ?>
                                    </span>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <a href="<?= base_url('Campaign-Donate-Form/' . $item['id']) ?>" class="btn me-1 donate_btn" target="_blank">
                                            <i class="fa-solid fa-heart"></i> Donate
                                        </a>
                                    </div>
                                    <div>
                                        <a href="<?= base_url('campaign_details/' . $item['id']) ?>" class="btn btn-sm btn-details">
                                            <i class="fas fa-info-circle me-1"></i>Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12 no-campaigns">
                    <div class="text-center">
                        <i class="fas fa-exclamation-circle fa-3x text-muted mb-3"></i>
                        <h4>No campaigns found</h4>
                        <p class="text-muted">There are currently no campaigns available.</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Pagination -->
        <?php if (isset($pager) && $pager->getPageCount() > 1): ?>
            <div class="pagination-container">
                <?= $pager->links() ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Image Modal -->
    <div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="" id="modalImage" class="img-fluid" style="max-height: 80vh;">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

<!-- Footer -->
  <footer style="background-image: linear-gradient(91deg, #F68302 0%, #08314F 89%);">
      <div style="padding-top:25px;">
          <div class="logo_box">
              <a href="<?php echo str_replace('/software/', '', base_url()); ?>">
  <img src="<?php echo base_url('websiteLogoImages/'.$dataweb['web_logo'])?>" class="winggo_logo_radius">
</a>
        </div>
      </div>
        <div class="contact_info_box">
            <h3 class="contact_info">Contact Info</h3>
        </div>
        
    <div class="footer-content">
        
      <div class="footer-column">
        <p><i class="fas fa-phone"></i> <?php echo $dataweb['site_mobile_1']?></p>
      </div>
      <div class="footer-column">
        <p><i class="fas fa-envelope"></i>  <?php echo $dataweb['webemail_1']?></p>
       
      </div>
      <div class="footer-column">
        <p><i class="fas fa-map-marker-alt"></i> <?php echo $dataweb['website_address'] ?></p>
        
      </div>
    </div>
    <div class="copyright">
       <!-- footer --> 
            <?php require_once($_SERVER['DOCUMENT_ROOT'] . '/software/app/Views/footer.php'); ?>
        <!-- / footer -->
    </div>
  </footer>    


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
   <script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".show-more-btn").forEach(function (btn) {
        btn.addEventListener("click", function () {
            let id = this.getAttribute("data-id");
            let desc = document.getElementById("desc-" + id);
            let dots = desc.querySelector(".dots");
            let moreText = desc.querySelector(".more-text");

            if (moreText.style.display === "none") {
                moreText.style.display = "inline";
                dots.style.display = "none";
                this.textContent = "Show Less";
            } else {
                moreText.style.display = "none";
                dots.style.display = "inline";
                this.textContent = "Show More";
            }
        });
    });
});
</script>
 
    
    
    
    
    
    <script>
        $(document).ready(function() {
            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
            
            // Filter functions
            function filterCampaigns() {
                const searchText = $('#searchInput').val().toLowerCase();
                const category = $('#categoryFilter').val();
                const status = $('#statusFilter').val();
                const amount = $('#amountRange').val();
                
                let visibleCount = 0;
                
                $('.campaign-item').each(function() {
                    const title = $(this).data('title');
                    const itemCategory = $(this).data('category');
                    const itemStatus = $(this).data('status');
                    const itemAmount = $(this).data('amount');
                    
                    const matchesSearch = title.includes(searchText) || searchText === '';
                    const matchesCategory = category === '' || itemCategory === category;
                    const matchesStatus = status === '' || itemStatus === status;
                    const matchesAmount = amount === '0' || itemAmount <= amount;
                    
                    if (matchesSearch && matchesCategory && matchesStatus && matchesAmount) {
                        $(this).show();
                        visibleCount++;
                    } else {
                        $(this).hide();
                    }
                });
                
                $('#campaignCount').text(visibleCount);
                
                // Remove any existing "no results" message
                $('.no-campaigns').remove();
                
                if (visibleCount === 0) {
                    $('#campaignsContainer').append(`
                        <div class="col-12 no-campaigns">
                            <div class="text-center">
                                <i class="fas fa-exclamation-circle fa-3x text-muted mb-3"></i>
                                <h4>No campaigns match your filters</h4>
                                <p class="text-muted">Try adjusting your search criteria.</p>
                            </div>
                        </div>
                    `);
                }
            }
            
            // Event listeners
            $('#searchInput, #categoryFilter, #statusFilter, #amountRange').on('input change', filterCampaigns);
            
            $('#amountRange').on('input', function() {
                const val = $(this).val();
                $('#amountValue').text(val === '0' ? 'Any' : 'Up to ₹' + parseInt(val).toLocaleString());
            });
            
            // Initialize
            filterCampaigns();
        });
    </script>
</body>
</html>