<?php

namespace App\Models;

use CodeIgniter\Model;

class ExpenseModel extends Model
{
    protected $table = 'expenses';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'user_id',
        'name',
        'amount',
        'receiptImage',
        'productName',
        'expense_category',
        'paid_to',
        'payment_mode',
        'project_name',
        'description',
        'expense_date',
    ];
    protected $useTimestamps = true;

public function getDataByDateRange($startDate, $endDate)
    {
        // Perform a query to retrieve data within the specified date range
        return $this->where('expense_date >=', $startDate)
                    ->where('expense_date <=', $endDate)
                    ->findAll();
    }
}