<?php

namespace App\Models;
use CodeIgniter\Model;

class CampaignModel extends Model
{
    protected $table = 'campaigns';

    protected $allowedFields = [
        'title',
        'category',
        'description',
        'goal_amount',
        'start_date',
        'end_date',
        'featured_image',
        'gallery_images',
        'video_url',
        'status',
        'created_at',
        'update_at'
    ];
    
    
    

public function getDataByDateRange($startDate, $endDate)
    {
        // Perform a query to retrieve data within the specified date range
        return $this->where('created_at >=', $startDate)
                    ->where('created_at <=', $endDate)
                    ->findAll();
    }    
    
}
