// app/Helpers/custom_helper.php

if (!function_exists('convertNumberToWords')) {
    function convertNumberToWords($number) {
        $number = (int)$number;
        $words = '';

        $units = ['', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine'];
        $teens = ['', 'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'];
        $tens = ['', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];
        $thousands = ['', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion'];

        $numChunks = array_reverse(array_chunk(str_split($number), 3));
        foreach ($numChunks as $key => $chunk) {
            $chunkNum = (int) implode('', array_reverse($chunk));
            if ($chunkNum > 0) {
                $chunkWords = [];
                if ($chunkNum >= 100) {
                    $chunkWords[] = $units[$chunkNum / 100] . ' hundred';
                    $chunkNum %= 100;
                }
                if ($chunkNum >= 20) {
                    $chunkWords[] = $tens[$chunkNum / 10];
                    $chunkNum %= 10;
                }
                if ($chunkNum > 0) {
                    if ($chunkNum >= 11 && $chunkNum <= 19) {
                        $chunkWords[] = $teens[$chunkNum - 10];
                    } else {
                        $chunkWords[] = $units[$chunkNum];
                    }
                }
                $words = implode(' ', $chunkWords) . ' ' . $thousands[$key] . ' ' . $words;
            }
        }

        return trim($words);
    } 
}
