<?php namespace App\Controllers;
use App\Models\UserModel;
use CodeIgniter\Controller;
use App\Models\CertificateModel;
use App\Models\CommonModel;
use App\Models\Donote_TransactionModel;
use App\Models\Message_controller;
use Dompdf\Dompdf;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
 use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf; 
use CodeIgniter\I18n\Time;

use Dompdf\Options;
use Endroid\QrCode\QrCode;
 class User_dashboard extends Controller
 {
     
public function ActiveReferral($id)
{
    $session = session();
    $userModel = new UserModel();

    // Step 1: Validate session
    $loggedUser = $userModel->where('id', $session->id)->first();
    if (!$loggedUser) {
        return redirect()->to('signin')->with('error', 'Unauthorised Access!');
    }

    // Step 2: Ensure current user is allowed
    if ($loggedUser['user_type'] !== "user") {
        return redirect()->to('signin')->with('error', 'Unauthorised Access!');
    }

    // Step 3: Decode referral ID
    $referralId = base64_decode($id);
    if (!$referralId) {
        return redirect()->to('signin')->with('error', 'Invalid Referral ID!');
    }

    // Step 4: Check target user (whose referral we are viewing)
    $targetUser = $userModel->where('id', $referralId)->first();
    if (!$targetUser) {
        return redirect()->to('signin')->with('error', 'User not found!');
    }

    // Step 5: Verify status and profile
    if ($targetUser['status'] === 'block') {
        return redirect()->to('signin')->with('error', 'This account is blocked!');
    }

    if (empty($targetUser['profile'])) {
        return redirect()->to('signin')->with('error', 'Profile not found!');
    }

    // Step 6: Get all active referrals for this user
    $data = [
        'heading' => "Active Member Referral",
        'users'   => $loggedUser,
        'user'    => $userModel->where('referralId', $referralId)
                               ->where('status', 'active')
                               ->findAll(),
    ];

    return view('user_dashboard/ReferralData', $data);
}


 public function InactiveReferral($id)
{
    $session = session();
    $userModel = new UserModel();

    
    $loggedUser = $userModel->where('id', $session->id)->first();
    if (!$loggedUser) {
        return redirect()->to('signin')->with('error', 'Unauthorised Access!');
    }

   
    if ($loggedUser['user_type'] !== "user") {
        return redirect()->to('signin')->with('error', 'Unauthorised Access!');
    }

   
    $referralId = base64_decode($id);
    if (!$referralId) {
        return redirect()->to('signin')->with('error', 'Invalid Referral ID!');
    }

  
    $targetUser = $userModel->where('id', $referralId)->first();
    if (!$targetUser) {
        return redirect()->to('signin')->with('error', 'User not found!');
    }

   
    if ($targetUser['status'] === 'block') {
        return redirect()->to('signin')->with('error', 'This account is blocked!');
    }

    if (empty($targetUser['profile'])) {
        return redirect()->to('signin')->with('error', 'Profile not found!');
    }

  
    $data = [
        'heading' => "Inactive Member Referral",
        'users'   => $loggedUser,
        'user'    => $userModel->where('referralId', $referralId)
                               ->where('status', 'inactive')
                               ->findAll(),
    ];

    return view('user_dashboard/ReferralData', $data);
}


     public function user_dashboard()
     {
         
          $model=new UserModel();  
    $oneYearAgo = date('Y-m-d', strtotime('-1 year'));
    $expiredUsers = $model->where('status', 'active')
                         ->where('verifie_date <=', $oneYearAgo)
                         ->findAll();
    
    
    if(!empty($expiredUsers)) {
        foreach($expiredUsers as $user) {
            $model->update($user['id'], ['status' => 'inactive']);
        }
    }
         
         
         $session = session();
         $userModel = new UserModel();
        $data = $userModel->where('id', $session->id)->first();
        if($data){
        $sess_data = [
                     'id'       => $data['id'],
                     'name'     => $data['name'],
                     'mobile'     => $data['mobile'],
                     'city'     => $data['city'],
                      
                      'profile_update'     => $data['profile_update'],
                     'email'    => $data['email'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                      'district' => $data['district'],
                      'nationality'=>$data['nationality'],
                      
                      'payment_status'=>$data['payment_status'],
                     'user_type' => $data['user_type'],
                      'loginned' =>'loginned',
                 ];

                  $session=session();
                $session->set($sess_data);
                $data['users'] = $userModel->where('id', $session->id)->first();
                
        return view('user_dashboard/index',$data);
     }
     else{
          return view('404error');
         
     }
     }
     
     
     public function checkCredentials()
{
    /*if (!csrf_filter()) {
        return $this->response->setJSON([
            'success' => false,
            'valid' => false, // Added for consistency
            'error_type' => 'system',
            'message' => 'Session expired. Please refresh the page.'
        ]);
    }*/

    $email = $this->request->getPost('email');
    $password = $this->request->getPost('password');
    $userModel = new UserModel();
    $user = $userModel->where('email', $email)->first();

    if (!$user) {
        return $this->response->setJSON([
            'success' => false,
            'valid' => false,
            'error_type' => 'email',
            'message' => 'Email not registered'
        ]);
    }

    if (!password_verify($password, $user['password'])) {
        return $this->response->setJSON([
            'success' => false,
            'valid' => false,
            'error_type' => 'password',
            'message' => 'Incorrect password'
        ]);
    }
    
    return $this->response->setJSON([
        'success' => true,
        'valid' => true, // Added for consistency
        'message' => 'Credentials verified'
    ]);
}
     
 public function checkEmail()
{
    
    $email = $this->request->getPost('email');

    
   $userModel = new UserModel();

   
    $user = $userModel->where('email', $email)->first();

    if ($user) {
         
        return $this->response->setJSON([
            'success' => false,
            'message' => 'This email is already taken. Please use a different email address.',
        ]);
    
    }
    else {
        
        return $this->response->setJSON([
            'success' => true,
            'message' => 'Email is Available!',
        ]);
    }
}    
   
   
   
   public function checkEmailF()
{
   // Ensure it's an AJAX request
        if (!$this->request->isAJAX()) {
            return $this->response->setStatusCode(403)->setJSON([
                'success' => false,
                'message' => 'Access denied'
            ]);
        }

        // Get email from POST data
        $email = $this->request->getPost('email');

        // Basic validation
        if (empty($email)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Email is required'
            ]);
        }

        // Validate email format
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Invalid email format'
            ]);
        }

        // Check if email exists in DB
        $userModel = new UserModel();
        $user = $userModel->where('email', $email)->first();

        if ($user) {
            $mobile = $user['mobile'];
            $maskedMobile = substr($mobile, 0, 2) . '*****' . substr($mobile, -3);
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Hint Mobile No.-'.$maskedMobile
            ]);
        } else {
            return $this->response->setJSON([
                'success' => true,
                'message' => 'Email is Invalid'
            ]);
        }

}
   
   
   

     public function checkMobile()

{
    
    $mobile = $this->request->getPost('mobile');

    
   $userModel = new UserModel();

   
    $user = $userModel->where('mobile', $mobile)->first();

    if ($user) {
         
        return $this->response->setJSON([
            'success' => false,
            'message' => 'This mobile number is already taken. Please use a different mobile number.',
        ]);
    
    }
    else {
        
        return $this->response->setJSON([
            'success' => true,
            'message' => 'Mobile is Available!',
        ]);
    }
}
     public function keyword_search_admin(){
        
        $keyword = $this->request->getPost();
        
        $userModel = new UserModel();
        $session = session();
            $data['users'] = $userModel->orwhere('id', $keyword)->orWhere('email',$keyword)->orWhere('mobile',$keyword)->orWhere('name',$keyword)->first();
            if($data['users']){
                
                 $userModel = new UserModel();
        $session = session();
            $data['user'] = $userModel->where('id', $session->id)->first();
                
                 $data['users'] = $userModel->orwhere('id', $keyword)->orWhere('email',$keyword)->orWhere('mobile',$keyword)->orWhere('name',$keyword)->findall();
                 
                     return view('admin_dashboard/search_keyword',$data);
            }
            else{
                $userModel = new UserModel();
        $session = session();
            $data['user'] = $userModel->where('id', $session->id)->first();
            
                 $custModel = new CustomerModel();
                $data['users'] = $custModel->orwhere('id', $keyword)->orWhere('cust_name',$keyword)->orWhere('cust_mobile',$keyword)->orWhere('cust_email',$keyword)->findall();
                return view('admin_dashboard/search_keyword',$data);
                
            }
    
       
        
    }


      public function membership_status($user_id){
          $session = session();
          $model=new UserModel();
        if (!$session->has('id')) {
    return redirect()->to('signin')->with('msg', 'Please login first!');
}

          $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
          if($users) {
         if($users['profile'] != null) {
                              if($users['status'] !='block') { 
                               if($users['status'] == 'active') { 
          $data['users']= $model->where('id', $user_id)->first();
        return view('user_dashboard/membership_status', $data);
                               }
                               else{
                                   
                                   return redirect()->to('user_dashboard'); 
                               }
                              }else{
                                  return redirect()->to('user_dashboard'); 
                              }
         }
         else{
             return redirect()->to('user_dashboard'); 
         }
          }else{
              return view('signin');
          }
      }
     
     public function profile($user_id=null){
         
 $userModel = new UserModel();
        $data = $userModel->where('id', $user_id)->first();
        if($data){
        if($data['transaction_id']==null){
            
          $db = \Config\Database::connect();
    $builder = $db->table('occupations');
   $data['occupations'] = $builder->orderBy('id', 'DESC')->get()->getResult();
   $data['amount'] = $builder->where('id', $data['designation'])->Orwhere('designation', $data['designation'])->get()->getRow();
       $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
        return view('user_dashboard/membership_apply', $data);
        }
        else {
            
    return redirect()->to(base_url('membership_status/').$data['id']);
    
        }
        }else{
          return redirect()->to('signin');   
        }

  }
   public function edit_view_profile($user_id=null){

  $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
             
                              if($users['status'] !='block') 
                              { 
                               if($users['status'] == 'active')
                               { 
     $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
        
      
        return view('user_dashboard/update_profile', $data);
                               }
                               else {return redirect()->to('user_dashboard');}
                              }
                              else {return redirect()->to('user_dashboard');}
         }
         else {
             
             return redirect()->to('user_dashboard');
             
         }
        

  }
  
  public function user_view_profile($user_id=null){
       $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
             
                              if($users['status'] !='block') 
                              { 
                               if($users['status'] == 'active')
                               { 
      
      $userModel = new UserModel();
        $data['user'] = $userModel->where('id', $user_id)->first();
       
      return view('user_dashboard/user_view_profile', $data);
  }
                               else {return redirect()->to('user_dashboard');}
                              }
                              else {return redirect()->to('user_dashboard');}
         }
         else {return redirect()->to('user_dashboard');}
      
  }
  public function send_message_by_user($user_id){
      
      $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
             
                              if($users['status'] !='block') 
                              { 
                               if($users['status'] == 'active')
                               { 
    $model=new UserModel();
         $data['users'] = $model->where('id', $user_id)->first();
        $msgModel = new Message_controller();
            $data['users_msg'] = $msgModel->where('msg_user_id', $user_id)->findAll();
        return view('user_dashboard/send_message_by_user', $data);
                               }
                               else {return redirect()->to('user_dashboard');}
                              }
                              else {return redirect()->to('user_dashboard');}
         }
         else {return redirect()->to('user_dashboard');}
}
public function id_card_downlod__show_pdf($user_id){
     $model=new UserModel();
         $data['users'] = $model->where('id', $user_id)->first();
    return view('user_dashboard/id_card_view', $data);
}

public function generateIdCardPdf($id)
{
    // Load user data
    $userModel = new UserModel();
    $user = $userModel->find($id);
    
    if (!$user) {
        return $this->response->setStatusCode(404)->setBody('User not found');
    }
$userModel = new UserModel();
    $data['users'] = $userModel->find($id);
    // Generate PDF using Dompdf or similar library
     $dompdf = new \Dompdf\Dompdf(); 
        $dompdf->set_option('isRemoteEnabled', TRUE);
    $html = view('user_dashboard/id-card_mobile_download', $data);
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    
    // Save to file
    $pdfPath = WRITEPATH . 'uploads/id_cards/' . $user['id'] . '.pdf';
    file_put_contents($pdfPath, $dompdf->output());
    
    // Return PDF for download
    return $this->response->download($pdfPath, null);
}


public function uploadPdf()
{
    // Verify authentication
    if (!session()->get('loginned')) {
        return $this->response->setStatusCode(401)->setJSON(['error' => 'Unauthorized']);
    }

    // Validate file upload
    $validation = service('validation');
    $validation->setRules([
        'pdf' => 'uploaded[pdf]|max_size[pdf,5120]|ext_in[pdf,pdf]|mime_in[pdf,application/pdf]',
        'user_id' => 'required|numeric'
    ]);

    if (!$validation->withRequest($this->request)->run()) {
        return $this->response->setStatusCode(400)->setJSON(['error' => $validation->getErrors()]);
    }

    // Process file upload
    $file = $this->request->getFile('pdf');
    $userId = $this->request->getPost('user_id');
    
    // Create user-specific directory if needed
    $uploadPath =  'uploads/id_cards/' . $userId . '/';
    if (!is_dir($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }

    // Generate unique filename
    $newName = 'id_card_' . time() . '.pdf';
    
    if ($file->isValid() && !$file->hasMoved()) {
        $file->move($uploadPath, $newName);
        
        // Return public URL
        return $this->response->setJSON([
            'pdfUrl' => base_url('uploads/id_cards/' . $userId . '/' . $newName)
        ]);
    }

    return $this->response->setStatusCode(500)->setJSON(['error' => 'File upload failed']);
}


public function id_card_mobile_download($user_id){
      $session = session();
     $model=new UserModel();
      $data = $model->where('id', $user_id)->first();
       if($data['profile'] != null) {
             
                              if($data['status'] !='block') 
                              { 
                               if($data['status'] == 'active')
                               { 
         $data['users'] = $model->where('id', $user_id)->first();
    return view('user_dashboard/id-card_mobile_download', $data);
}
                               else {
                                  if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              } 
                               }
                              }
                              else {
                                 if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              } 
                              }
         }
          else {
              if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              }
          }
         }
 
        public function MembershipCertificate($user_id){
         $session = session();
             $model=new UserModel();
      $data = $model->where('id', $user_id)->first();
       if($data['profile'] != null) {
             
                              if($data['status'] !='block') 
                              { 
                               if($data['status'] == 'active')
                               { 
         $data['users'] = $model->where('id', $user_id)->first();
    return view('user_dashboard/Membership-Certificate', $data);
}
                               else {
                                  if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              } 
                               }
                              }
                              else {
                                 if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              } 
                              }
         }
          else {
              if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              }
          }
            
        }  

public function send_message_by_user_data(){
    
    
     
    $userModel = new UserModel();
   
     $id = $this->request->getPost('id');
    
     $user_msg = $this->request->getPost('msg');
       $user_name = $this->request->getPost('name');
       


/*image upload*/

      
      

                   $data = [
                'msg_user_id'     => $id,
                
                  'msg'     => $user_msg,
                  'user_name'    =>$user_name,
                    'user_type' => "user",
                       
            'msg_date'=> date('Y-m-d H:i:s'),

                
    ];
 
     $msgModel = new Message_controller();
         $result =   $msgModel->save($data);
         /*= $this->userModel->update($user_id, $data);*/
         if($result){
             
       $model=new UserModel();
         $data['users'] = $model->where('id', $id)->first();

           $msgModel = new Message_controller();
            $data['users_msg'] = $msgModel->where('msg_user_id', $id)->findAll();
            
            
         $session=session();
                    $session->set("msg","Send Message Successfully !");
                    $session->markAsFlashdata("msg");
        return view('user_dashboard/send_message_by_user', $data);
         }
         else{
            $session=session();
                    $session->set("msg","Message Not Send");
                    $session->markAsFlashdata("msg");
                     $model=new UserModel();
         $data['users'] = $model->where('user_id', $id)->first(); 
            echo view('user_dashboard/user_dashboard', $data);
         }
                
}
  public function search_user()
  {
   $keyword = $this->request->getPost('keyword');   
      
      
  }
 public function edit_view_profile_data()
{
    $userModel = new UserModel();
    $session = session();

    $id = $this->request->getPost('id');
    $postData = $this->request->getPost();

    $data = [
        'name'            => $this->request->getPost('name'),
        'father_name'     => $this->request->getPost('father_name'),
        
        'married_status'  => $this->request->getPost('married_status'),
        'gender'          => $this->request->getPost('gender'),
        'mobile'          => $this->request->getPost('mobile'),
        'state'           => $this->request->getPost('state'),
        'district'        => $this->request->getPost('district'),
        'address'         => $this->request->getPost('address'),
        'designation'     => $this->request->getPost('designation'),
        'occupation'      => $this->request->getPost('occupation'),
        'aadhar_card_no'  => $this->request->getPost('aadhar_card_no'),
        'profile_update'  => date('Y-m-d H:i:s')
    ];
    if (!empty($postData['day']) && !empty($postData['month']) && !empty($postData['year'])) {
        $data['dob'] = "{$postData['day']}-{$postData['month']}-{$postData['year']}";
    }
    
    $profileImage = $this->request->getFile('profile');
    if ($profileImage && $profileImage->isValid() && !$profileImage->hasMoved()) {
        try {
            $newFileName = $profileImage->getRandomName();
            if ($profileImage->move("images", $newFileName)) {
                $data['profile'] = $newFileName;
                
               
                $oldUser = $userModel->find($postData['id']);
                if (!empty($oldUser['profile']) && file_exists("images/".$oldUser['profile'])) {
                    unlink("images/".$oldUser['profile']);
                }
            }
        } catch (\Exception $e) {
            log_message('error', 'Profile image upload failed: '.$e->getMessage());
        }
    }
    
    if ($userModel->update($id, $data)) {
        $session->setFlashdata('msg', 'Your Profile Details Updated Successfully!');
          return redirect()->to('user_dashboard');
    } else {
        $session->setFlashdata('msg', 'Something went wrong while updating your profile.');
        return redirect()->back()->withInput();
    }
}

 public function update_user_profile()
{
   
    $userModel = new UserModel();
    $session = session();
    
    
    $postData = $this->request->getPost();
    
    // Validate required fields
    if (empty($postData['id'])) {
        $session->setFlashdata('msg', 'User ID is required');
        return redirect()->back();
    }
    
    
    $data = [
        'id' => $postData['id'],
        'name' => $postData['name'] ?? null,
        'mobile' => $postData['mobile'] ?? null,
        'email' => $postData['email'] ?? null,
        'gender' => $postData['gender'] ?? null,
        'married_status' => $postData['marital_status'] ?? null,
         'blood_group' => $postData['blood_group'] ?? null,
          'category' => $postData['category'] ?? null,
        'father_name' => $postData['father_name'] ?? null,
        'occupation' => !empty($postData['otherOccupation']) 
                       ? $postData['otherOccupation'] 
                       : ($postData['occupation'] ?? null),
        'pin_code' => $postData['pin_code'] ?? null,
        'address' => $postData['address'] ?? null,
        'state' => $postData['state'] ?? null,
        'district' => $postData['district'] ?? null,
        'aadhar_card_no' => $postData['aadhar_card_no'] ?? null,
        'designation' => $postData['designation'] ?? null,
        'profile_update' => date('Y-m-d H:i:s')
    ];
    
    
    if (!empty($postData['day']) && !empty($postData['month']) && !empty($postData['year'])) {
        $data['dob'] = "{$postData['day']}-{$postData['month']}-{$postData['year']}";
    }
    

    $profileImage = $this->request->getFile('profile');
    if ($profileImage && $profileImage->isValid() && !$profileImage->hasMoved()) {
        try {
            $newFileName = $profileImage->getRandomName();
            if ($profileImage->move("images", $newFileName)) {
                $data['profile'] = $newFileName;
                
               
                $oldUser = $userModel->find($postData['id']);
                if (!empty($oldUser['profile']) && file_exists("images/".$oldUser['profile'])) {
                    unlink("images/".$oldUser['profile']);
                }
            }
        } catch (\Exception $e) {
            log_message('error', 'Profile image upload failed: '.$e->getMessage());
        }
    }
    
  
    try {
        $result = $userModel->update($postData['id'], $data);
        
        if ($result) {
           
            $updatedUser = $userModel->find($postData['id']);
            
            
            $session->setFlashdata(
                'msg', 
                '<h1>Congratulations</h1>Your membership application has been successfully submitted. '.
                'Please wait for the administrator to verify your application.'
            );
            
            return redirect()->to(base_url('profile/').$updatedUser['id']);
        } else {
            $session->setFlashdata(
                'msg', 
                'Your Profile Details Update Successfully! Follow Next Step After Active Your Account.'
            );
            return redirect()->to('user_dashboard');
        }
    } catch (\Exception $e) {
        log_message('error', 'User profile update failed: '.$e->getMessage());
        $session->setFlashdata('msg', 'An error occurred while updating your profile');
        return redirect()->back();
    }
}
                



  public function user_upload_payment_data($user_id=null){
$userModel = new UserModel();
        $data['user_obj'] = $userModel->where('user_id', $user_id)->first();
        return view('user_dashboard/user_upload_payment_data', $data);

  }


  public function user_upload_payment_data_save(){
     helper(['form', 'url']);
          $user_id = $this->request->getVar('user_id');
        if ($this->request->getMethod()=="post") {
            
              $user_id = $this->request->getVar('user_id');
            $trans_name = $this->request->getVar('trans_name');
             $trans_mobile = $this->request->getVar('trans_mobile');
              $payment_amount = $this->request->getVar('payment_amount');
              $transaction_id = $this->request->getVar('transaction_id');
              
            $fileinfo = $this->request->getFile('payment_pic');
            if(!empty($fileinfo)){
                $filename= $fileinfo->getName();
                $nameArray = explode(".",$filename);
                $newfileName= time().".". end($nameArray); 
                if($fileinfo->move("payments_images",$newfileName)){

                   $data = [
                
                 'trans_name'     => $trans_name,
                 'user_id'     => $user_id,
                 'trans_mobile'     => $trans_mobile,
                 'payment_amount'     => $payment_amount,

                  'transaction_id'     => $transaction_id,
                  'payment_pic'     =>  $newfileName,
                  'payment_status'  => '0',
                ];
 

     $userModel = new UserModel();
         $result = $userModel->where(["user_id" =>$user_id])
                   ->set($data)
                   ->update();
         /*= $this->userModel->update($user_id, $data);*/
         if($result){
             
             $session=session();
                    $session->set("msg","Your Transaction Details Successfully uplaod ! Some Second Wait After Active Your Account.");
                    $session->markAsFlashdata("msg");
             
            echo view('user_dashboard/user_dashboard');
         }
         else{
            echo "Something went Wrong";
         }
                }
                    else
                    {
                        echo "File not Upload";
                        //error
                    }
                }
            }
        }

        public function print_id_card_by_user($user_id=null){
          $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
                              if($users['status'] !='block') { 
                               if($users['status'] == 'active') { 

             $userModel = new UserModel();
        $data['users']= $userModel->where('id', $user_id)->first();
         return view('user_dashboard/print_id_card_by_user', $data);
                               }
                               else{
                                    return redirect()->to('user_dashboard');
                               }
                              }else{  
                                   return redirect()->to('user_dashboard');
                              }
         }
         else { return redirect()->to('user_dashboard');
             
         }
        
     
        }

        public function print_id_card_by_user_process($user_id=null)
        {
            $userModel = new UserModel();
        $data['user_obj'] = $userModel->where('user_id', $user_id)->first();
        
        $dompdf = new \Dompdf\Dompdf(); 
        $dompdf->set_option('isRemoteEnabled', TRUE);
       $dompdf->loadHtml(view('user_dashboard/print_id_card_by_user_process', $data));
        $dompdf->setPaper('A4', 'portrait ');
        $dompdf->render();
        $dompdf->stream('myfile.pdf', ['Attachment' => TRUE]);
        
       
        }

        public function appointment_letter_by_user($user_id=null){
            
            $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
                              if($users['status'] !='block') { 
                               if($users['status'] == 'active') { 
        $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
        
       return view('user_dashboard/appointment_letter_by_user', $data);
                         } else {return redirect()->to('user_dashboard');
                             }
                              }else {return redirect()->to('user_dashboard');
                             }
         }else {return redirect()->to('user_dashboard');
                             }
        }
                              
       public function appointment_letter_by_process(){

            $session = session();
         $model = new UserModel();
          $user_id = $this->request->getVar('user_id');
         $aadhar_card_no = $this->request->getVar('aadhar_card_no');
         $dob = $this->request->getVar('dob');
        
         $data = $model->where('aadhar_card_no', $aadhar_card_no)->where('dob', $dob)->first();
       
        if($data){
         
             
            
                 $sess_data = [
                     'user_id'       => $data['user_id'],
                     'uname'     => $data['uname'],
                     'uemail'    => $data['uemail'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                     'user_type' => $data['user_type'],
                     'address' => $data['address'],
                     'profile_update' => $data['profile_update'],
                     'status' => $data['status'],
                      'loginned' =>'loginned',
                 ];

                  $session=session();
                $session->set($sess_data);
                 if($data['status']=="active"){
                    $session=session();
                    $session->set("msg","");
                    $session->markAsFlashdata("msg");
                    $userModel = new UserModel();
    $data['users'] = $userModel->where('user_id', $data['user_id'])->first();
    
         return view('user_dashboard/appointment_letter_by_user_generate', $data);
                   /* $url="User_dashboard";*/
                }

                 else
               {
                    $session=session();
                    $session->set("msg","Your Profile is Underprosessing, 😊 ");
                    $session->markAsFlashdata("msg");
                    $userModel = new UserModel();
    $data['users'] = $userModel->where('user_id', $data['user_id'])->first();
                return view('user_dashboard/appointment_letter_by_user',$data);

                }

              
               
              }
              else{
               $session=session();
                    $session->set("msg","Your Aadhar Card No. OR Date of Birth not match your profile data. 😊 ");
                    $session->markAsFlashdata("msg");
                    $userModel = new UserModel();
    $data['users'] = $userModel->where('user_id', $user_id)->first();
                return view('user_dashboard/appointment_letter_by_user',$data);
              }
              
          }

          public function print_appointment_by_user_process($user_id = null){
$session = session();
             $userModel = new UserModel();
        $data = $userModel->where('id', $user_id)->first();
        if($data['profile'] != null) {
             
                              if($data['status'] !='block') 
                              { 
                               if($data['status'] == 'active')
                               { 
$data['users'] = $userModel->where('id', $user_id)->first();
       return view('user_dashboard/print_appointment_by_user_process',$data);
          }
                              
          else {
              if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              }
              }
         }else{
             if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              }
         }
          }
          else {
              
              if($session->user_type=="admin"){
              return redirect()->to('admin_dashboard');
                  
              }else{
                  return redirect()->to('user_dashboard');
              }
          }
          }
  public function certificate_by_user($user_id)
{
    $session = session();
    $userModel = new UserModel();

    // Step 1: Validate logged-in user
    $loggedUser = $userModel->where('id', $session->id)->first();
    if (!$loggedUser) {
        return redirect()->to('signin')->with('error', 'Unauthorised Access!');
    }

    // Step 2: Ensure current user type is "user"
    if ($loggedUser['user_type'] !== "user") {
        return redirect()->to('signin')->with('error', 'Unauthorised Access!');
    }

    // Step 3: Validate target user
    $targetUser = $userModel->where('id', $user_id)->first();
    if (!$targetUser) {
        return redirect()->to('user_dashboard')->with('msgcerti', 
            '<h1>Oops!</h1>User not found.'
        );
    }

    // Step 4: Check profile and status
    if (empty($targetUser['profile']) || $targetUser['status'] === 'block') {
        return redirect()->to('user_dashboard')->with('msgcerti', 
            '<h1>Oops!</h1>This account is blocked or profile not found.'
        );
    }

    // Step 5: Get certificates for this user
    $ceriModel = new CertificateModel();
    $certificates = $ceriModel->where('user_id', $user_id)->findAll();

    if (empty($certificates)) {
        return redirect()->to('user_dashboard')->with('msgcerti', 
            '<h1>Oops!</h1>Engage in social work to earn an Achievement Certificate. 
            The certificate will be displayed here when the admin grants you any certificate.'
        );
    }

    // Step 6: Pass data to view
    $data = [
        'users' => $targetUser,
        'certificate' => $certificates
    ];

    return view('user_dashboard/certificate_print_process', $data);
}


    public function certificate_appointment_by_user_data(){
         $user_id = $this->request->getVar('user_id');
        $session = session();
         $model = new UserModel();
         $aadhar_card_no = $this->request->getVar('aadhar_card_no');
         $dob = $this->request->getVar('dob');
         $data = $model->where('aadhar_card_no', $aadhar_card_no)->where('dob', $dob)->first();
        if($data){
         
             $sess_data = [
                     'user_id'       => $data['user_id'],
                     'uname'     => $data['uname'],
                     'uemail'    => $data['uemail'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                     'user_type' => $data['user_type'],
                     'address' => $data['address'],
                     'profile_update' => $data['profile_update'],
                     'status' => $data['status'],
                      'loginned' =>'loginned',
                 ];

                  $session=session();
                $session->set($sess_data);
                 if($data['status']=="active"){
                  // code here admin certificate;
                  $Certificate_model=new CertificateModel();
              $data['user'] = $Certificate_model->getDataById($user_id);
             
             $userModel = new UserModel();
        $data['users'] = $userModel->where('user_id', $user_id)->first();
                    $session=session();
                    $session->set("msg","Your Certificate Successfully Generate, ");
                    $session->markAsFlashdata("msg");
                   return view('user_dashboard/certificate_by_user_generate',$data);
                   /* $url="User_dashboard";*/
                }

                 else
               {
                    $session=session();
                    $session->set("msg","Your Profile is Underprosessing -- Not Active Your Account? , 😊 ");
                    $session->markAsFlashdata("msg");
                return view('user_dashboard/user_dashboard');

                }

              
               
              }
              else{
                $userModel = new CertificateModel();
             $data['user'] = $userModel->getDataById($user_id);
              $userModel = new UserModel();
        $data['users'] = $userModel->where('user_id', $user_id)->first();
               $session=session();
                    $session->set("msg","Your Aadhar Card No. OR Date of Birth not match your profile data ");
                    $session->markAsFlashdata("msg");
                return view('user_dashboard/certificate_print_process',$data);
              }
    }
    
    public function view_certificate($roll_no,$user_id){
         
       // code here admin certificate;
                  $Certificate_model=new CertificateModel(); 
                  $data = $Certificate_model->where('certificate_no',$roll_no)->first();
                  
                  $dateString = $data['gen_date'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datatime']=['formattedDate'=>$formattedDate,
                                 
                                ];
              $data['user'] = $Certificate_model->where('certificate_no',$roll_no)->first();
             
             $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
      
      
      
        
                  return view('user_dashboard/certificate_download_view',$data);
                //   /* $url="User_dashboard";*/
        
    }
    
     public function print_view_certificate($roll_no,$user_id){
         
       // code here admin certificate;
                  $Certificate_model=new CertificateModel(); 
                
              $data['user'] = $Certificate_model->where('certificate_no',$roll_no)->first();
             
             $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
      
      // Create a QR code
      require 'vendor/autoload.php';
//$qrCode = new QrCode('hhttps://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js');

// Require composer autoload
// require_once 'vendor/autoload.php';

$mpdf = new \Mpdf\Mpdf();
$mpdf->DefOrientation = 'portrait';
     // Embed the HTML content with the QR code
     $html = '<html><body>';
     $html .= view('user_dashboard/certificate_download_view',$data);
     // Add other content as needed
     $html .= '</body></html>';
     
     // Load HTML into mPDF
     $mpdf->WriteHTML($html);
         $userModel = new UserModel();
        $data = $userModel->where('id', $user_id)->first();
                  $name=$data['name'];
                
       // Set headers to force download and specify the filename
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="$name.pdf"');

// Output the PDF
// $pdf = $mpdf->Output('my-file.pdf', 'I')->setContentType('application/pdf');

// return $pdf; 

// Output the PDF
//$mpdf->Output('.pdf');
 $mpdf->Output($name.'.pdf', 'D');
     
      
        
                //     $session=session();
                //     $session->set("msg","Your Certificate Successfully Generate, ");
                //     $session->markAsFlashdata("msg");
                //   return view('user_dashboard/certificate_download_view',$data);
                //   /* $url="User_dashboard";*/
        
    }
    
public function print_certificate_by_user_process($user_id=null){
     $css = '<link rel="stylesheet" href="public/css/style.css">';
     $html = '<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Sofia&effect=fire">';
    $userModel = new UserModel();
        $data['user_obj'] = $userModel->where('id', $user_id)->first();





// using image tag that will output to the browser.


       

       $dompdf = new \Dompdf\Dompdf(); 
        $dompdf->loadHtml($css.$html);
        $dompdf->set_option('isRemoteEnabled', true);
        $dompdf->loadHtml(view('user_dashboard/print_certificate_by_user_process'));
        $dompdf->setPaper('A4', 'portrait');
       
        $dompdf->render ();
        $dompdf->stream ("Test.pdf", array ("Attachment" => false));

        /*return view('user_dashboard/print_certificate_by_user_process');*/
    }

public function view_certificate_download($id)
{
  $Certificate_model=new CertificateModel(); 
                
              $data = $Certificate_model->where('certificate_id',$id)->first();
             
                  $dateString = $data['gen_date'];

// Create a Time instance from the date string
$date = Time::parse($dateString);

// Format the date
$formattedDate = $date->toLocalizedString('dd-MM-yyyy');

// Display the formatted date

            
            $data['datatime']=['formattedDate'=>$formattedDate,
                                 
                                ];
                                $Certificate_model=new CertificateModel(); 
                
              $data['user'] = $Certificate_model->where('certificate_id',$id)->first();
                $session=session();
                    $session->set("msg","Your Certificate Successfully Generate, ");
                    $session->markAsFlashdata("msg");
                  return view('user_dashboard/certificate_download_view',$data);   
    
}
public function forgot_password(){

  return view('forgot_password');
  
}

public function otp_form(){
             
              $to   = $this->request->getVar('email');
              $otp = rand(1111,9999);
     helper(['form']);
        $rules = [
          
            
            'email'           => 'required|min_length[4]|max_length[100]',
            
        ];
  $session=session();
             $userModel = new UserModel();
       
        if($this->validate($rules))

        {
             $userModel = new UserModel();
             $data = $userModel->where('uemail', $to)->first();
            $id=$data['user_id'];
                  
                  
                  
          
            $data = [

                 'otp'             => $otp,
                 'verification_status' => '0',
                
             ];
           if($data){
          
             $userModel = new UserModel();
            $userModel->update($id, $data);
          
             $userModel = new UserModel();
             $data['users'] = $userModel->where('uemail', $to)->first();
          
            $otp = $data['otp'];
         
       //Import PHPMailer classes into the global namespace
//These must be at the top of your script, not inside a function


//Load Composer's autoloader
require 'vendor/autoload.php';
require 'phpmailer/src/PHPMailer.php';
require 'phpmailer/src/Exception.php';
require 'phpmailer/src/SMTP.php';
//Create an instance; passing `true` enables exceptions
$mail = new PHPMailer(true);
  $queryli = "SELECT * FROM admin_website_update";
                         $result = mysqli_query($connection, $queryli);
                         $dataweb = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $result = mysqli_query($connection, "SELECT * FROM email_credentials LIMIT 1");
    $email_data = mysqli_fetch_array($result, MYSQLI_ASSOC);

    $resultweb = mysqli_query($connection, "SELECT * FROM admin_website_update LIMIT 1");
    $web_data = mysqli_fetch_array($resultweb, MYSQLI_ASSOC);
try {
    //Server settings
    $mail->SMTPDebug = 0;                      //Enable verbose debug output
    $mail->isSMTP();                                            //Send using SMTP
      $mail->Host       = $email_data['host'];                     //Set the  $mail->SMTPAuth   = true;
        $mail->Username   = $email_data['by_email'];
        $mail->Password   = $email_data['by_password'];
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        // Recipients
        $mail->setFrom($email_data['by_email'], $email_data['subject']);
        $mail->addAddress($user['email'], $user['name']);
    $mail->isHTML(true);                                  //Set email format to HTML
    $mail->Subject = 'Here is the subject';
    $mail->Body    = 'This is the HTML message body <b>Your OTP:</b>'.$otp;
    $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

    $mail->send();
   $session=session();
            $data['validation'] = $this->validator;
            
             $userModel = new UserModel();
             $data['users'] = $userModel->where('uemail', $to)->first();
            $session->set("msg","OTP Sent Your Register Email  ! Check inbox mail");
            $session->markAsFlashdata("msg");
            return view('otp_form',$data);
} 
catch (Exception $e) {
    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
}
}
}

        else
        {
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msg","Email  ! Enter details some thing wrong ?");
            $session->markAsFlashdata("msg");
            return view('forgot_password');
        }
             
         }
         
         
         
        public function match_otp(){
        
      
              $email   = $this->request->getVar('email');
               $otp   = $this->request->getVar('otp');
             
     helper(['form']);
        $rules = [
          
            
            'email'           => 'required|min_length[4]|max_length[100]',
            
        ];
  $session=session();
             $userModel = new UserModel();
       
        if($this->validate($rules))

        {
             $userModel = new UserModel();
            $data = $userModel->where('uemail', $email)->where('otp', $otp)->first();
            $id=$data['user_id'];
                  
                  
        if($data){
          
             $userModel = new UserModel();
            $userModel->update($id, $data);
          
             $userModel = new UserModel();
             $data['users'] = $userModel->where('uemail', $email)->first();
          
        
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msg"," Enter New Password ?");
            $session->markAsFlashdata("msg");
            return view('change_forgot_password_form',$data);
       
         
       //Import PHPMailer classes into the global namespace
//These must be at the top of your script, not inside a function



}
else
        {
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msg","OTP Does Not match ?");
            $session->markAsFlashdata("msg");
             $userModel = new UserModel();
             $data['users'] = $userModel->where('uemail', $email)->first();
            return view('forgot_password', $data);
        }  
}

        else
        {
            $session=session();
            $data['validation'] = $this->validator;
            $session->set("msg","Email  ! Enter details some thing wrong ?");
            $session->markAsFlashdata("msg");
            return view('forgot_password');
        }  
        
    }     
       
       
         public function change_password_data(){
        
        $password   = $this->request->getVar('password');
         $cpassword   = $this->request->getVar('cpassword');
          $id   = $this->request->getVar('id');
            $to   = $this->request->getVar('email');
             
   
  $session=session();
             $userModel = new UserModel();
       
        if($password == $cpassword)

        {
             $userModel = new UserModel();
             $data = $userModel->where('uemail', $to)->first();
            $id=$data['user_id'];
                  
                  
                  
          
            $data = [

                
                 'verification_status' => '1',
                 'upassword'=> password_hash($this->request->getVar('password'), PASSWORD_DEFAULT),
                
             ];
           if($data){
          
             $userModel = new UserModel();
            $userModel->update($id, $data);
          
             $userModel = new UserModel();
             $data['users'] = $userModel->where('uemail', $to)->first();
             
             $session=session();
            
            $session->set("msg","Your Password Change Succesfully  ?");
            $session->markAsFlashdata("msg");
             return redirect()->to('loginsignup');
          
            
}
}

        else
        {
            $session=session();
            
            $session->set("msg","Your Password Does Not match try again ?");
            $session->markAsFlashdata("msg");
            
             $userModel = new UserModel();
             $data['users'] = $userModel->where('id', $id)->first();
            return view('change_forgot_password_form',$data);
        }
        
        
    }  

public function user_aadhar_verifie(){


  $session = session();
         $model = new UserModel();
         $aadhar_card_no = $this->request->getVar('aadhar_card_no');
        
         $data = $model->where('aadhar_card_no', $aadhar_card_no)->first();
         if($data){
             $aadhar_card_no = $data['aadhar_card_no'];
            
             if($aadhar_card_no){
                 $sess_data = [
                     'user_id'       => $data['user_id'],
                     'uname'     => $data['uname'],
                     'uemail'    => $data['uemail'],
                     'father_name'   => $data['father_name'],
                      'profile'   => $data['profile'],
                     'user_type' => $data['user_type'],
                      'loginned' =>'loginned',
                 ];
                 
                 $userModel = new UserModel();
        $data['users'] = $userModel->where('user_id', $data['user_id'])->first();
       
                 return view('user_dashboard/user_forgot_password_view', $data);
                  
            }
            else{
                $session=session();
                $session->set("msg","Aadhar Card No. does not match try again !");
                $session->markAsFlashdata('failed_message');
                return redirect()->back()->withInput();
            }
            }

         else
         {
            return redirect()->back()->withInput();

         }

}

public function user_aadhar_verifie_process(){
  $model = new UserModel();
         $user_id = $this->request->getVar('user_id');
         $upassword = $this->request->getVar('upassword');
         
         /* include helper form */
        helper(['form']);
        /* set rules validation form */
        $rules = [
            'user_id'          => 'required',
           
            'upassword'      => 'required|min_length[6]|max_length[200]',
            'upassword'  => 'matches[upassword]'
        ];
         
        if($this->validate($rules)){
            $model = new UserModel();
            $data = [
              
              
                'upassword' => password_hash($this->request->getVar('upassword'), PASSWORD_DEFAULT)
            ];
            
           
          $userModel = new UserModel();
         $userModel->set('upassword', $data)
         ->where('user_id', $user_id)
         ->update();
      
            $session=session();
            $session->set("msg","Password Change Successfully ? ");
            $session->markAsFlashdata("msg");
            return redirect()->to('logout');
          }
          else{
              $session=session();
            $session->set("msg","Some things Wrong try again ? ");
            $session->markAsFlashdata("msg");
            echo view('loginsignup', $data);
          }
}

public function donate_receipt_view($id=null){
      
      
      $trans= new Donote_TransactionModel();
         $data = $trans->where('user_id', $id)->findAll(); 
         if($data){
             
             $model=new UserModel();
         $data['users']= $model->where('id', $id)->first();
             
              $trans= new Donote_TransactionModel();
         $data['receipt'] = $trans->where('user_id', $id)->findAll(); 
             
              return view('user_dashboard/donate_receipt_view',$data);
             
         }
      else{
          $session=session();
            $session->set("msg","You Have No Any Donated Receipt ? ");
            $session->markAsFlashdata("msg");
         return redirect()->to('user_dashboard'); 
      }
  }

  public function donate_view($user_id=null)
     {
         $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
                              if($users['status'] !='block') { 
                               if($users['status'] == 'active') { 
         $session = session();
         $userModel = new UserModel();
        $data['users'] = $userModel->where('id', $user_id)->first();
        
        return view('user_dashboard/donate_view',$data);
                               }
                               else { return redirect()->to('user_dashboard');}
                              }
                               else { return redirect()->to('user_dashboard');}
         } else { return redirect()->to('user_dashboard');}
     }   
public function user_profile($user_id=null)
     {
         $model=new UserModel();
         $users= $model->where('id', $user_id)->first();
         if($users['profile'] != null) {
                              if($users['status'] !='block') { 
                               if($users['status'] == 'active') { 
         $session = session();
         $userModel = new UserModel();
        $data['user'] = $userModel->where('id', $user_id)->first();
        
        return view('user_dashboard/user_profile',$data);
                               }
                               else { return redirect()->to('user_dashboard');}
                              }
                               else { return redirect()->to('user_dashboard');}
         } else { return redirect()->to('user_dashboard');}
     }   
  public function admin_by_reason($id){
     
      $user_reason = $this->request->getVar('user_reason');
      $data =[
          'reason_msg'=>$user_reason,
          ];
      
        $model=new UserModel();
        
        $model->update($id,$data);
         $session=session();
            $session->set("msg","This  Send Response Message Successfully? ? ");
            $session->markAsFlashdata("msg");
         return redirect()->to('user_dashboard');
        
  }
 }